#include "Research_MechUtilHeaders.h"
#include "ResearchManagerAgent.h"

Research_SiegeModeGoalGenerator::Research_SiegeModeGoalGenerator(AgentPool* a, ResearchManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 32; // remember this
	thresh = 25;
	parent = par;

	// this is just a placeholder, this generator is capible of producing two types of goals
	// see below.
	goal = new GoalDescriptor(RESEARCH_MECHUTIL_SIEGEMODE, priority, TechTypes::Tank_Siege_Mode.mineralPrice(), TechTypes::Tank_Siege_Mode.gasPrice(), agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Research_SiegeModeGoalGenerator::instantiateGoal() {
	////////////////////////agentPool->writeDebugMessage("declared goal to research bio weapons");
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Research_SiegeModeGoalGenerator::inhibit() {

}

void Research_SiegeModeGoalGenerator::initialize() {

}

void Research_SiegeModeGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

	if(i->hasUnit(UnitTypes::Terran_Machine_Shop)) {
		if(!goal->accepted() && !goal->isExecuting()) {
			if(drive >= thresh) {
				if(instantiateGoal()) {
					////////////////////////agentPool->writeDebugMessage("intention accepted");
					drive = 0;
				}
			} else {

				if(!Broodwar->self()->hasResearched(TechTypes::Tank_Siege_Mode) && i->hasUnit(UnitTypes::Terran_Factory) && i->hasUnit(UnitTypes::Terran_Machine_Shop)) {
					// cool, now this generator's responsibility is to lobby for
					// researching stim packs
				if(drive < thresh) {
						drive++;
					}
				} else { // some other stuff we'lll think about later

				}


	
			}





		}

		if(goal->isExecuting()) {
			BWAPI::Unit* researchingInstution = goal->getMonitorTarget();

			if(researchingInstution->isResearching() || Broodwar->self()->hasResearched(TechTypes::Tank_Siege_Mode)) {
				goal->relinquishResources();
				int remainingResearchTime = researchingInstution->getRemainingResearchTime();
					goal->finish();
					drive = 0;
				//}
			}

			//if(Broodwar->self()->hasResearched(TechTypes::Stim_Packs)) {
			//	////////////////////////agentPool->writeDebugMessage("we have this research! finishign!");
			//	goal->finish();
			//}
			//if(Broodwar->self()->getUpgradeLevel(UpgradeTypes::U_238_Shells) != 0) {
			//	////////////////////////agentPool->writeDebugMessage("we have this research! finishign!");
			//	goal->finish();
			//}

		}
	}
}


int Research_SiegeModeGoalGenerator::getthresh() {
	return thresh;
}

int Research_SiegeModeGoalGenerator::getdrive() {
	return drive;
}
