#include "Research_BuildingUpgradeHeaders.h"
#include "InformationManagerAgent.h"

Research_ScienceFacilityUpgradeGoalGenerator::Research_ScienceFacilityUpgradeGoalGenerator(AgentPool* a, ResearchManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 7; // remember this
	thresh = 25;
	parent = par;

	// this is just a placeholder, this generator is capible of producing two types of goals
	// see below.
	goal = new GoalDescriptor(UPGRADE_SCIENCEFACILITY, priority, UnitTypes::Terran_Physics_Lab.mineralPrice(), UnitTypes::Terran_Physics_Lab.gasPrice(), agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Research_ScienceFacilityUpgradeGoalGenerator::instantiateGoal() {
	////////////////////////agentPool->writeDebugMessage("declared goal to upgrade command centre");
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Research_ScienceFacilityUpgradeGoalGenerator::inhibit() {

}

void Research_ScienceFacilityUpgradeGoalGenerator::initialize() {

}

void Research_ScienceFacilityUpgradeGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
	if(!goal->accepted() && !goal->isExecuting()) {
		if(!goal->accepted() && !goal->isExecuting()) {
			if(drive >= thresh) {
				if(instantiateGoal()) {
					////////////////////////agentPool->writeDebugMessage("intention accepted");
					drive = 0;
				}
			} else {

				if(i->hasUnit(UnitTypes::Terran_Science_Facility) && !i->hasUnit(UnitTypes::Terran_Physics_Lab)) {
					if(drive < thresh) {
						drive++;
					}
				}
			}

		}
	}
	if(goal->isExecuting()) {
		BWAPI::Unit* researchingInstution = goal->getMonitorTarget();
		////////////////////agentPool->writeDebugMessage("STARPORT getting construction time:");
		if(researchingInstution->getAddon() != NULL) {
			//if(researchingInstution->getAddon()->isConstructing()) {
			
			if(researchingInstution->getAddon()->isConstructing()) {
				goal->relinquishResources();
			int remainingResearchTime = researchingInstution->getRemainingBuildTime();
			////////////////////agentPool->writeDebugMessage("STARPORT time left on upgrade build:");
			////////////////////agentPool->writeDebugMessage(remainingResearchTime);
			//if(remainingResearchTime <= 10) {
				////////////////////agentPool->writeDebugMessage("build done!");
				//goal->accept();
				goal->finish();
				drive = 0;
			//}
			//}

		} else {
			////////////////////agentPool->writeDebugMessage("STARPORT not building");
			goal->relinquishResources();
			goal->retry();
		}
	}
	}
}


int Research_ScienceFacilityUpgradeGoalGenerator::getthresh() {
	return thresh;
}

int Research_ScienceFacilityUpgradeGoalGenerator::getdrive() {
	return drive;
}
