#include "Research_MechAttackAndDefenseHeaders.h"
#include "ResearchManagerAgent.h"

Research_MechDefenseGoalGenerator::Research_MechDefenseGoalGenerator(AgentPool* a, ResearchManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 7; // remember this
	thresh = 50;
	parent = par;

	// this is just a placeholder, this generator is capible of producing two types of goals
	// see below.
	goal = new GoalDescriptor(RESEARCH_MECHDEFENSE, priority, UpgradeTypes::Terran_Infantry_Armor.mineralPrice(), UpgradeTypes::Terran_Infantry_Armor.gasPrice(), agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Research_MechDefenseGoalGenerator::instantiateGoal() {
	//////////////////////////agentPool->writeDebugMessage("declared goal to research bio weapons");
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Research_MechDefenseGoalGenerator::inhibit() {

}

void Research_MechDefenseGoalGenerator::initialize() {

}

void Research_MechDefenseGoalGenerator::updateDrives() {
	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
	int upgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Vehicle_Weapons);
	int armorupgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Vehicle_Plating);
		if(i->countUnitType(Terran_Armory) < 2) {
	if(upgradeLevel < armorupgradeLevel) {
		goal->setInhibit(true);
	} else {
		goal->setInhibit(false);
	}
		}

	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;


	if(i->hasUnit(UnitTypes::Terran_Engineering_Bay)) {
		if(!goal->accepted() && !goal->isExecuting()) {

			if(drive >= thresh) {
				int upgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Vehicle_Plating);

				goal->modifyPrice(UpgradeTypes::Terran_Vehicle_Plating.mineralPrice(upgradeLevel), UpgradeTypes::Terran_Vehicle_Plating.gasPrice(upgradeLevel));
				if(instantiateGoal()) {
					drive = 0;
				}
			} else {

				int upgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Vehicle_Plating);
				if(upgradeLevel < 3) {

					if(drive < thresh) {
						drive++;
					}
				}

			}





		}

		if(goal->isExecuting()) {
			BWAPI::Unit* researchingInstution = goal->getMonitorTarget();

			if(researchingInstution->isUpgrading()) {
				goal->relinquishResources();
				int remainingResearchTime = researchingInstution->getRemainingUpgradeTime();
				if(researchingInstution->getRemainingResearchTime() < 40) {
					drive = 0;

					goal->finish();
				}

			}

		}
	}
}


int Research_MechDefenseGoalGenerator::getthresh() {
	return thresh;
}

int Research_MechDefenseGoalGenerator::getdrive() {
	return drive;
}
