#include "Research_MechAttackAndDefenseHeaders.h"
#include "ResearchManagerAgent.h"

Research_MechAttackGoalGenerator::Research_MechAttackGoalGenerator(AgentPool* a, ResearchManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 8; // remember this
	thresh = 40;
	parent = par;

	// this is just a placeholder, this generator is capible of producing two types of goals
	// see below.
	goal = new GoalDescriptor(RESEARCH_MECHATTACK, priority, 0, 0, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Research_MechAttackGoalGenerator::instantiateGoal() {
	//////////////////////////agentPool->writeDebugMessage("declared goal to research bio weapons");
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Research_MechAttackGoalGenerator::inhibit() {

}

void Research_MechAttackGoalGenerator::initialize() {

}

void Research_MechAttackGoalGenerator::updateDrives() {
InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
	int upgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Vehicle_Weapons);
	int armorupgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Vehicle_Plating);
	if(i->countUnitType(Terran_Armory) < 2) {
	if(upgradeLevel > armorupgradeLevel) {
		goal->setInhibit(true);
	} else {
		goal->setInhibit(false);
	}
	}
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	

	if(i->hasUnit(UnitTypes::Terran_Engineering_Bay)) {
		if(!goal->accepted() && !goal->isExecuting()) {

			if(drive >= thresh) {
				int upgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Vehicle_Weapons);

				goal->modifyPrice(UpgradeTypes::Terran_Vehicle_Weapons.mineralPrice(upgradeLevel), UpgradeTypes::Terran_Vehicle_Weapons.gasPrice(upgradeLevel));

				if(instantiateGoal()) {
					//////////////////////////agentPool->writeDebugMessage("intention accepted");
					drive = 0;
				}
			} else {

				int upgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Vehicle_Weapons);
				if(upgradeLevel <= 3) {

					if(drive < thresh) {
						drive++;
					}
				}

			}





		}

		if(goal->isExecuting()) {
			BWAPI::Unit* researchingInstution = goal->getMonitorTarget();

			if(researchingInstution->isUpgrading()) {
				goal->relinquishResources();
				if(researchingInstution->getRemainingResearchTime() < 40) {
					drive = 0;
					goal->finish();
				}



			}
		}
	}
}


int Research_MechAttackGoalGenerator::getthresh() {
	return thresh;
}

int Research_MechAttackGoalGenerator::getdrive() {
	return drive;
}
