#include "Research_BioUtilHeaders.h"
#include "ResearchManagerAgent.h"

Research_MarineShellsGoalGenerator::Research_MarineShellsGoalGenerator(AgentPool* a, ResearchManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 4; // remember this
	thresh = 50;
	parent = par;

	// this is just a placeholder, this generator is capible of producing two types of goals
	// see below.
	goal = new GoalDescriptor(RESEARCH_BIOWEAPONS_MARINERANGE, priority, UpgradeTypes::U_238_Shells.mineralPrice(), UpgradeTypes::U_238_Shells.gasPrice(), agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Research_MarineShellsGoalGenerator::instantiateGoal() {
	//////////////////////////agentPool->writeDebugMessage("declared goal to research bio weapons");
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Research_MarineShellsGoalGenerator::inhibit() {

}

void Research_MarineShellsGoalGenerator::initialize() {

}

void Research_MarineShellsGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

	if(i->hasUnit(UnitTypes::Terran_Academy)) {
		if(!goal->accepted() && !goal->isExecuting()) {
			if(drive >= thresh) {
				if(instantiateGoal()) {
					//////////////////////////agentPool->writeDebugMessage("intention accepted");
					drive = 0;
				}
			} else {


				//////////////////////////agentPool->writeDebugMessage("util drive");
				// firstly, do we already have stim packs?
				if(Broodwar->self()->getUpgradeLevel(UpgradeTypes::U_238_Shells) == 0) {
					if(drive < thresh) {
						drive++;
					}
				}



			}





		}

		if(goal->isExecuting()) {
			BWAPI::Unit* researchingInstution = goal->getMonitorTarget();

			if(researchingInstution->isResearching() || Broodwar->self()->getUpgradeLevel(UpgradeTypes::U_238_Shells) != 0) {
				goal->relinquishResources();
				int remainingResearchTime = researchingInstution->getRemainingResearchTime();
				//////////////////////////agentPool->writeDebugMessage("time left on research:");
				//////////////////////////agentPool->writeDebugMessage(remainingResearchTime);
				//if(remainingResearchTime <= 10) {
					//////////////////////////agentPool->writeDebugMessage("research done!");
					goal->relinquishResources();
					goal->finish();
					drive = 0;
					return;
				//}
			}
			if(researchingInstution->isUpgrading()) {
				//goal->relinquishResources();
				int remainingResearchTime = researchingInstution->getRemainingUpgradeTime();
				//////////////////////////agentPool->writeDebugMessage("time left on research:");
				//////////////////////////agentPool->writeDebugMessage(remainingResearchTime);
			//	if(remainingResearchTime <= 10) {
					//////////////////////////agentPool->writeDebugMessage("research done!");
					goal->relinquishResources();
					//goal->accept();
					goal->finish();
					drive = 0;
					return;
				//}
			}

			//if(Broodwar->self()->hasResearched(TechTypes::Stim_Packs)) {
			//	//////////////////////////agentPool->writeDebugMessage("we have this research! finishign!");
			//	goal->finish();
			//}
			//if(Broodwar->self()->getUpgradeLevel(UpgradeTypes::U_238_Shells) != 0) {
			//	//////////////////////////agentPool->writeDebugMessage("we have this research! finishign!");
			//	goal->finish();
			//}

		}
	}
}


int Research_MarineShellsGoalGenerator::getthresh() {
	return thresh;
}

int Research_MarineShellsGoalGenerator::getdrive() {
	return drive;
}
