#include "Research_MechUtilHeaders.h"
#include "ResearchManagerAgent.h"

Research_IonThrusterGoalGenerator::Research_IonThrusterGoalGenerator(AgentPool* a, ResearchManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 18; // remember this
	thresh = 25;
	parent = par;

	// this is just a placeholder, this generator is capible of producing two types of goals
	// see below.
	goal = new GoalDescriptor(RESEARCH_MECHUTIL_IONTHRUSTERS, priority, UpgradeTypes::Ion_Thrusters.mineralPrice(), UpgradeTypes::Ion_Thrusters.gasPrice(), agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Research_IonThrusterGoalGenerator::instantiateGoal() {
	////////////////////////agentPool->writeDebugMessage("declared goal to research bio weapons");
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Research_IonThrusterGoalGenerator::inhibit() {

}

void Research_IonThrusterGoalGenerator::initialize() {

}

void Research_IonThrusterGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

	if(i->hasUnit(UnitTypes::Terran_Machine_Shop)) {
		if(!goal->accepted() && !goal->isExecuting()) {
			if(drive >= thresh) {
				if(instantiateGoal()) {
					////////////////////////agentPool->writeDebugMessage("intention accepted");
					drive = 0;
				}
			} else {

				if(!Broodwar->self()->hasResearched(TechTypes::Tank_Siege_Mode) && i->hasUnit(UnitTypes::Terran_Factory) && i->hasUnit(UnitTypes::Terran_Machine_Shop)) {
					// cool, now this generator's responsibility is to lobby for
					// researching stim packs
					if(drive < thresh) {
						drive++;
					}
				} else { // some other stuff we'lll think about later

				}



			}





		}

		if(goal->isExecuting()) {
			BWAPI::Unit* researchingInstution = goal->getMonitorTarget();

			if(researchingInstution->isUpgrading() || Broodwar->self()->getUpgradeLevel(UpgradeTypes::Ion_Thrusters) != 0) {
				goal->relinquishResources();
				goal->finish();
				drive = 0;
			}
		}
	}
}


int Research_IonThrusterGoalGenerator::getthresh() {
	return thresh;
}

int Research_IonThrusterGoalGenerator::getdrive() {
	return drive;
}
