#include "Research_BuildingUpgradeHeaders.h"
#include "InformationManagerAgent.h"

Research_FactoryUpgradeGoalGenerator::Research_FactoryUpgradeGoalGenerator(AgentPool* a, ResearchManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 7; // remember this
	thresh = 40;
	parent = par;
	temporalFactor = 0;
	// this is just a placeholder, this generator is capible of producing two types of goals
	// see below.
	goal = new GoalDescriptor(UPGRADE_FACTORY, priority, UnitTypes::Terran_Machine_Shop.mineralPrice(), UnitTypes::Terran_Machine_Shop.gasPrice(), agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Research_FactoryUpgradeGoalGenerator::instantiateGoal() {
	//////////////////////agentPool->writeDebugMessage("declared intention to upgrade factory");
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Research_FactoryUpgradeGoalGenerator::inhibit() {

}

void Research_FactoryUpgradeGoalGenerator::initialize() {

}

void Research_FactoryUpgradeGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
	if(!goal->accepted() && !goal->isExecuting()) {

			if(drive >= thresh) {
				if(instantiateGoal()) {
					//////////agentPool->writeDebugMessage("accepted build machine shop!");
					drive = 0;
							temporalFactor = 0;
				} else {
					//////////agentPool->writeDebugMessage("denied build machine shop!");
				}
			} else {
				if(i->countUnitType(UnitTypes::Terran_Factory) > i->countUnitType(UnitTypes::Terran_Machine_Shop)) {

					if(drive < thresh) {
							drive++;
						}
				}
			}
	}


	if(goal->isExecuting()) {
		BWAPI::Unit* researchingInstution = goal->getMonitorTarget();
		if(researchingInstution->getAddon() == NULL) {
		temporalFactor++;
		if(temporalFactor > 1000) {
			////////////////agentPool->writeDebugMessage("construction of: ");
			////////////////agentPool->writeDebugMessage(goal->getNaturalName());	
			////////////////agentPool->writeDebugMessage("--- abandoning due to time constraints");	
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			return;
		}
		}

		if(researchingInstution->getAddon() != NULL) {
			goal->relinquishResources();
			//if(researchingInstution->isConstructing()) {
				
				int remainingResearchTime = researchingInstution->getAddon()->getRemainingBuildTime();
					goal->relinquishResources();
					goal->finish();
							temporalFactor = 0;
							drive = 0;
				//}
			//}

		}
	}
}


int Research_FactoryUpgradeGoalGenerator::getthresh() {
	return thresh;
}

int Research_FactoryUpgradeGoalGenerator::getdrive() {
	return drive;
}
