#include "Research_BuildingUpgradeHeaders.h"
#include "InformationManagerAgent.h"

Research_CommandCentreUpgradeGoalGenerator::Research_CommandCentreUpgradeGoalGenerator(AgentPool* a, ResearchManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 5; // remember this
	thresh = 50;
	parent = par;
	temporalFactor = 0;
	// this is just a placeholder, this generator is capible of producing two types of goals
	// see below.
	goal = new GoalDescriptor(UPGRADE_COMMANDCENTRE_COMSAT, priority, UnitTypes::Terran_Comsat_Station.mineralPrice(), UnitTypes::Terran_Comsat_Station.gasPrice(), agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Research_CommandCentreUpgradeGoalGenerator::instantiateGoal() {
	////////////////////////agentPool->writeDebugMessage("declared goal to upgrade command centre");
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Research_CommandCentreUpgradeGoalGenerator::inhibit() {

}

void Research_CommandCentreUpgradeGoalGenerator::initialize() {

}

void Research_CommandCentreUpgradeGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	if(!goal->accepted() && !goal->isExecuting()) {
		if(!goal->accepted() && !goal->isExecuting()) {
			if(drive >= thresh) {
				if(instantiateGoal()) {
					////////////////////////agentPool->writeDebugMessage("intention accepted");
					drive = 0;
				}
			} else {
				unsigned int numComSats = 0;
				std::vector<Unit*> commandCentres = im->getBuildingsOfType(UnitTypes::Terran_Command_Center);
				for(unsigned int i = 0; i < commandCentres.size(); i++) {
				if(!commandCentres.empty()) {
					if(commandCentres.at(i)->getAddon() != NULL) {
					//if(!commandCentres.at((i)->hasUnitUnderConstruction(Terran_Comsat_Station))) {
						numComSats++;
					//}
					}
				}
				}
				if(im->hasUnit(UnitTypes::Terran_Refinery) && commandCentres.size() > numComSats) {


				if(drive < thresh) {
					drive++;
				}
				}
			}

		}
	}
	if(goal->isExecuting()) {
		BWAPI::Unit* researchingInstution = goal->getMonitorTarget();
		//////////////////agentPool->writeDebugMessage("getting construction time for COMSAT:");
		//////////////////agentPool->writeDebugMessage(researchingInstution->getOrder().getName());
		if(researchingInstution->getAddon() != NULL) {
			//////////////////agentPool->writeDebugMessage("got the addon!");
			goal->relinquishResources();
			//if(researchingInstution->isConstructing()) {
				//goal->relinquishResources();
				int remainingResearchTime = researchingInstution->getRemainingBuildTime();
				////////////////////////agentPool->writeDebugMessage("time left on upgrade build:");
				////////////////////////agentPool->writeDebugMessage(remainingResearchTime);
				//if(remainingResearchTime <= 10) {
					////////////////////////agentPool->writeDebugMessage("build done!");
					goal->relinquishResources();
					goal->finish();
							temporalFactor = 0;
							drive = 0;
				//}
			//}

		} 
	}
}


int Research_CommandCentreUpgradeGoalGenerator::getthresh() {
	return thresh;
}

int Research_CommandCentreUpgradeGoalGenerator::getdrive() {
	return drive;
}
