#include "Research_MechUtilHeaders.h"
#include "ResearchManagerAgent.h"

Research_CharonBoostersGoalGenerator::Research_CharonBoostersGoalGenerator(AgentPool* a, ResearchManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 15; // remember this
	thresh = 25;
	parent = par;

	// this is just a placeholder, this generator is capible of producing two types of goals
	// see below.
	goal = new GoalDescriptor(RESEARCH_MECHUTIL_CHARONBOOSTERS, priority, UpgradeTypes::Charon_Boosters.mineralPrice(), UpgradeTypes::Charon_Boosters.gasPrice(), agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Research_CharonBoostersGoalGenerator::instantiateGoal() {
	////////////////////////agentPool->writeDebugMessage("declared goal to research bio weapons");
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Research_CharonBoostersGoalGenerator::inhibit() {

}

void Research_CharonBoostersGoalGenerator::initialize() {

}

void Research_CharonBoostersGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

	if(i->hasUnit(UnitTypes::Terran_Machine_Shop)) {
		if(!goal->accepted() && !goal->isExecuting()) {
			if(drive >= thresh) {
				if(instantiateGoal()) {
					////////////////////////agentPool->writeDebugMessage("intention accepted");
					drive = 0;
				}
			} else {

				if(!Broodwar->self()->getUpgradeLevel(UpgradeTypes::Charon_Boosters) == 0 && i->countUnitType(UnitTypes::Terran_Factory) >= 2 && i->hasUnit(UnitTypes::Terran_Machine_Shop)) {
					// cool, now this generator's responsibility is to lobby for
					// researching stim packs
					if(drive < thresh) {
						drive++;
					}
				} 



			}





		}

		if(goal->isExecuting()) {
			BWAPI::Unit* researchingInstution = goal->getMonitorTarget();

			if(researchingInstution->isUpgrading() || Broodwar->self()->getUpgradeLevel(UpgradeTypes::Charon_Boosters) != 0) {
				goal->relinquishResources();
				int remainingResearchTime = researchingInstution->getRemainingResearchTime();
				goal->finish();
				drive = 0;
				//}
			}

			//if(Broodwar->self()->hasResearched(TechTypes::Stim_Packs)) {
			//	////////////////////////agentPool->writeDebugMessage("we have this research! finishign!");
			//	goal->finish();
			//}
			//if(Broodwar->self()->getUpgradeLevel(UpgradeTypes::U_238_Shells) != 0) {
			//	////////////////////////agentPool->writeDebugMessage("we have this research! finishign!");
			//	goal->finish();
			//}

		}
	}
}


int Research_CharonBoostersGoalGenerator::getthresh() {
	return thresh;
}

int Research_CharonBoostersGoalGenerator::getdrive() {
	return drive;
}
