#include "Research_BioAttackAndDefenseHeaders.h"
#include "ResearchManagerAgent.h"

Research_BioDefenseGoalGenerator::Research_BioDefenseGoalGenerator(AgentPool* a, ResearchManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 8; // remember this
	thresh = 50;
	parent = par;

	// this is just a placeholder, this generator is capible of producing two types of goals
	// see below.
	goal = new GoalDescriptor(RESEARCH_BIODEFENSE, priority, UpgradeTypes::Terran_Infantry_Armor.mineralPrice(), UpgradeTypes::Terran_Infantry_Armor.gasPrice(), agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Research_BioDefenseGoalGenerator::instantiateGoal() {
	//////////////////////////agentPool->writeDebugMessage("declared goal to research bio weapons");
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Research_BioDefenseGoalGenerator::inhibit() {

}

void Research_BioDefenseGoalGenerator::initialize() {

}

void Research_BioDefenseGoalGenerator::updateDrives() {

	int upgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Infantry_Weapons);
	int armorupgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Infantry_Armor);

	if(upgradeLevel < armorupgradeLevel) {
		goal->setInhibit(true);
	} else {
		goal->setInhibit(false);
	}


	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

	if(i->hasUnit(UnitTypes::Terran_Engineering_Bay) && Broodwar->enemy()->getRace() != Races::Protoss) {
		if(!goal->accepted() && !goal->isExecuting()) {

			if(drive >= thresh) {
				int upgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Infantry_Armor);

				goal->modifyPrice(UpgradeTypes::Terran_Infantry_Armor.mineralPrice(upgradeLevel), UpgradeTypes::Terran_Infantry_Armor.gasPrice(upgradeLevel));
				if(instantiateGoal()) {
					drive = 0;
				}
			} else {

				int upgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Infantry_Armor);
				if(upgradeLevel <= 3) {

					if(drive < thresh) {
						drive++;
					}
				}

			}
		}

		if(goal->isExecuting()) {
			BWAPI::Unit* researchingInstution = goal->getMonitorTarget();

			if(researchingInstution->isUpgrading()) {
				goal->relinquishResources();
				int remainingResearchTime = researchingInstution->getRemainingUpgradeTime();
				if(researchingInstution->getRemainingResearchTime() < 40) {
					drive = 0;
					goal->finish();
				}

			}

		}
	}
}


int Research_BioDefenseGoalGenerator::getthresh() {
	return thresh;
}

int Research_BioDefenseGoalGenerator::getdrive() {
	return drive;
}
