#include "Research_BioAttackAndDefenseHeaders.h"
#include "ResearchManagerAgent.h"

Research_BioAttackGoalGenerator::Research_BioAttackGoalGenerator(AgentPool* a, ResearchManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 9; // remember this
	thresh = 40;
	parent = par;

	// this is just a placeholder, this generator is capible of producing two types of goals
	// see below.
	goal = new GoalDescriptor(RESEARCH_BIOATTACK, priority, 0, 0, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Research_BioAttackGoalGenerator::instantiateGoal() {
	//////////////////////////agentPool->writeDebugMessage("declared goal to research bio weapons");
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Research_BioAttackGoalGenerator::inhibit() {

}

void Research_BioAttackGoalGenerator::initialize() {

}

void Research_BioAttackGoalGenerator::updateDrives() {
	int upgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Infantry_Weapons);
	int armorupgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Infantry_Armor);

	if(upgradeLevel > armorupgradeLevel) {
		goal->setInhibit(true);
	} else {
		goal->setInhibit(false);
	}

	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");


	if(i->hasUnit(UnitTypes::Terran_Engineering_Bay) && Broodwar->enemy()->getRace() != Races::Protoss) {
		if(!goal->accepted() && !goal->isExecuting()) {

			if(drive >= thresh) {
				int upgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Infantry_Weapons);

					goal->modifyPrice(UpgradeTypes::Terran_Infantry_Weapons.mineralPrice(upgradeLevel), UpgradeTypes::Terran_Infantry_Weapons.gasPrice(upgradeLevel));
				if(instantiateGoal()) {
					drive = 0;
				}
			} else {

			int upgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Infantry_Weapons);
			int armorupgradeLevel = Broodwar->self()->getUpgradeLevel(UpgradeTypes::Terran_Infantry_Armor);
			
			if(upgradeLevel <= 3) {

				if(drive < thresh) {
						drive++;
					}
				}

			}
		}

		if(goal->isExecuting()) {
			BWAPI::Unit* researchingInstution = goal->getMonitorTarget();

			if(researchingInstution->isUpgrading()) {
				goal->relinquishResources();
					if(researchingInstution->getRemainingUpgradeTime() < 40) {
						drive = 0;
						goal->finish();
					}

					
					
				}
			}
		}
	}


int Research_BioAttackGoalGenerator::getthresh() {
	return thresh;
}

int Research_BioAttackGoalGenerator::getdrive() {
	return drive;
}
