#ifndef RESEARCHAGENT_H
#define RESEARCHAGENT_H
#include "AgentBase.h"
#include "BWAPI.h"
#include <vector>
#include "Research_BioUtilHeaders.h"
#include "Research_BioAttackAndDefenseHeaders.h"
#include "Research_BuildingUpgradeHeaders.h"
#include "Research_MechUtilHeaders.h"
#include "Research_MechAttackAndDefenseHeaders.h"

using namespace BWAPI;

class AgentPool;

class ResearchManagerAgent : public AgentBase {
public:
	ResearchManagerAgent::ResearchManagerAgent(AgentPool* p);
	ResearchManagerAgent::ResearchManagerAgent();
	virtual void updateDrives();
	virtual Arbitrator* getArbitrator() { return internalArbitrator; };
	
	Arbitrator* ResearchManagerAgent::getInternalArbitrator();

	bool ResearchManagerAgent::canBeResearched(BWAPI::TechType req);
	Unit* ResearchManagerAgent::researchTech(BWAPI::TechType req);

	bool ResearchManagerAgent::canBeUpgraded(BWAPI::UpgradeType req);
	Unit* ResearchManagerAgent::upgradeTech(BWAPI::UpgradeType req);

private:
	AgentPool* agentPool;
		Arbitrator* internalArbitrator;
		Research_StimPacksGoalGenerator* bioTechWeaponUpgradesGoalGenerator;
		Research_BioAttackGoalGenerator* bioTechAttackUpgradesGoalGenerator;
		Research_BioDefenseGoalGenerator* bioTechDefenseUpgradesGoalGenerator;
		Research_MarineShellsGoalGenerator* bioTechRangeUpgradeGoalGenerator;
		Research_IonThrusterGoalGenerator* ionThrustersGoalGenerator;
		Research_CharonBoostersGoalGenerator* charonBoostersGoalGenerator;
		Research_CommandCentreUpgradeGoalGenerator* commandCentreUpgradeGoalGenerator;
		Research_FactoryUpgradeGoalGenerator* factoryUpgradeGoalGenerator;
		Research_SiegeModeGoalGenerator* mechUtilGoalGenerator;
		Research_WraithCloakGoalGenerator* wraithCloakGoalGenerator;
		Research_StarportUpgradeGoalGenerator* starPortUpgradeGoalGenerator;
	//	Research_ScienceFacilityUpgradeGoalGenerator* scienceFacilityUpgradeGoalGenerator;
		Research_ScienceVesselIrradiateGoalGenerator* scienceFacilityIrradiateGoalGenerator;
		Research_ScienceVesselEMPGoalGenerator* scienceFacilityEMPGoalGenerator;
		Research_MechAttackGoalGenerator* mechTechWeaponUpgradesGoalGenerator;
		Research_MechDefenseGoalGenerator* mechTechArmorUpgradesGoalGenerator;

};
#endif