#include "ResearchManagerAgent.h"
#include "AgentPool.h"

ResearchManagerAgent::ResearchManagerAgent(AgentPool* p) {
	agentPool = p;
	internalArbitrator = new Arbitrator(p);
	bioTechWeaponUpgradesGoalGenerator = new Research_StimPacksGoalGenerator(agentPool, this);
	bioTechRangeUpgradeGoalGenerator = new Research_MarineShellsGoalGenerator(agentPool,this);
	bioTechAttackUpgradesGoalGenerator = new Research_BioAttackGoalGenerator(agentPool, this);
	bioTechDefenseUpgradesGoalGenerator = new Research_BioDefenseGoalGenerator(agentPool,this);
	commandCentreUpgradeGoalGenerator = new Research_CommandCentreUpgradeGoalGenerator(agentPool, this);
	factoryUpgradeGoalGenerator = new Research_FactoryUpgradeGoalGenerator(agentPool, this);
	mechUtilGoalGenerator = new Research_SiegeModeGoalGenerator(agentPool, this);
	wraithCloakGoalGenerator = new Research_WraithCloakGoalGenerator(agentPool, this);
	starPortUpgradeGoalGenerator = new Research_StarportUpgradeGoalGenerator(agentPool, this);
	//scienceFacilityUpgradeGoalGenerator = new Research_ScienceFacilityUpgradeGoalGenerator(agentPool, this);
	scienceFacilityIrradiateGoalGenerator = new Research_ScienceVesselIrradiateGoalGenerator(agentPool, this);
    scienceFacilityEMPGoalGenerator = new Research_ScienceVesselEMPGoalGenerator(agentPool, this);
	mechTechWeaponUpgradesGoalGenerator = new Research_MechAttackGoalGenerator(agentPool, this);
	mechTechArmorUpgradesGoalGenerator = new Research_MechDefenseGoalGenerator(agentPool, this);
	ionThrustersGoalGenerator = new Research_IonThrusterGoalGenerator(agentPool, this);
	charonBoostersGoalGenerator = new Research_CharonBoostersGoalGenerator(agentPool, this);
}

ResearchManagerAgent::ResearchManagerAgent() {

}

Arbitrator* ResearchManagerAgent::getInternalArbitrator() {
			return internalArbitrator;
}

void ResearchManagerAgent::updateDrives() {
	bioTechRangeUpgradeGoalGenerator->updateDrives();
	bioTechWeaponUpgradesGoalGenerator->updateDrives();
	bioTechAttackUpgradesGoalGenerator->updateDrives();
	bioTechDefenseUpgradesGoalGenerator->updateDrives();
	commandCentreUpgradeGoalGenerator->updateDrives();
	factoryUpgradeGoalGenerator->updateDrives();
	mechUtilGoalGenerator->updateDrives();
	starPortUpgradeGoalGenerator->updateDrives();
	wraithCloakGoalGenerator->updateDrives();
	mechTechWeaponUpgradesGoalGenerator->updateDrives();
	mechTechArmorUpgradesGoalGenerator->updateDrives();
		ionThrustersGoalGenerator->updateDrives();
		if(Broodwar->enemy()->getRace() != Races::Terran){
			charonBoostersGoalGenerator->updateDrives();
		}

	if(Broodwar->enemy()->getRace() == Races::Zerg || Broodwar->enemy()->getRace() == Races::Terran) {
		scienceFacilityIrradiateGoalGenerator->updateDrives();
	} else if(Broodwar->enemy()->getRace() == Races::Protoss) {
		scienceFacilityEMPGoalGenerator->updateDrives();
	}
		//////////agentPool->writeDebugMessage("errr");
}

// consider that this might be called constantly, thus suck
bool ResearchManagerAgent::canBeUpgraded(BWAPI::UpgradeType req) {
	//////agentPool->writeDebugMessage("looking to see if I can upgrade: ");
	//////agentPool->writeDebugMessage(req.getName());

	bool building = false;
	bool prereq = false;

	for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
	{
		if((*i)->getType().isBuilding() && (*i)->isCompleted()) {
			if((*i)->getType() == req.whatUpgrades()) {
				building = !(*i)->isUpgrading() && !(*i)->isTraining() && !(*i)->isResearching() && !(*i)->isConstructing();
			}
			if(building == true) {
				break;
			}
		}
	}
		for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
		{
		if((*i)->getType().isBuilding() && (*i)->isCompleted()) {
			if(((*i)->getType() == req.whatsRequired(Broodwar->self()->getUpgradeLevel(req))) || req.whatsRequired() == UnitTypes::None) {
				prereq = true;
			}
			if(building == true && prereq == true) {
				break;
			}
		  }
		}

	return (building == true && prereq == true);

}

// this is probably a bad idea. we probably need to keep all of our unit somewhere
// anyway, so might refer to that in the future?
Unit* ResearchManagerAgent::upgradeTech(BWAPI::UpgradeType req) {
	for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
	{
		if((*i)->getType().isBuilding()) {
			if((*i)->getType() == req.whatUpgrades()) {
				(*i)->upgrade(req);
				
				std::string name = req.getName().c_str();
				//////agentPool->writeDebugMessage("upgrading: " + name);
				return *i;
			}
		}
	}
	return NULL;
}


// consider that this might be called constantly, thus suck
bool ResearchManagerAgent::canBeResearched(BWAPI::TechType req) {
	//////////////////////////agentPool->writeDebugMessage("looking to see if I can research: ");
	//////////////////////////agentPool->writeDebugMessage(req.getName());

	for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
	{
		if((*i)->getType().isBuilding()) {
			if((*i)->getType() == req.whatResearches()) {
				return !(*i)->isUpgrading() && !(*i)->isTraining() && !(*i)->isResearching() && !(*i)->isConstructing() && (*i)->isCompleted();
			}
		}
	}
	//////////////////////////agentPool->writeDebugMessage("wasn't able to find it!");
	return false;
}

// this is probably a bad idea. we probably need to keep all of our unit somewhere
// anyway, so might refer to that in the future?
Unit* ResearchManagerAgent::researchTech(BWAPI::TechType req) {
	for(std::set<Unit*>::const_iterator i=Broodwar->self()->getUnits().begin();i!=Broodwar->self()->getUnits().end();i++)
	{
		if((*i)->getType().isBuilding() && (*i)->isCompleted()) {
			if((*i)->getType() == req.whatResearches()) {
				(*i)->research(req);
				return *i;
			}
		}
	}
	return NULL;
}