#ifndef OFFTAC_GOALHEADERS_H
#define OFFTAC_GOALHEADERS_H
#include "GoalGeneratorBase.h"
#include "GoalTypes.h"

class OffensiveTacticsManagerAgent;

// worker training goal
class OffensiveTactics_LandAttackGoalGenerator : public GoalGeneratorBase {
	public:
		OffensiveTactics_LandAttackGoalGenerator(AgentPool* a, OffensiveTacticsManagerAgent* parent);

		// generic stuff
		virtual void inhibit();
		virtual bool instantiateGoal();
		virtual void updateDrives();
		virtual void initialize();
		virtual int getdrive();
		virtual int getthresh();
		// what
		
	
	private:

		// generic stuff
		bool inhibited;
		AgentPool* agentPool;
		int drive;
		int thresh;
		int priority;
		OffensiveTacticsManagerAgent* parent;
		GoalDescriptor* goal;
		int temporalFactor;
		// implementation-specific stuff, if needed
		

};




class OffensiveTactics_GasSteal : public GoalGeneratorBase {
	public:
		OffensiveTactics_GasSteal(AgentPool* a, OffensiveTacticsManagerAgent* parent);

		// generic stuff
		virtual void inhibit();
		virtual bool instantiateGoal();
		virtual void updateDrives();
		void attachTargetDetails(int tac, Unit* rep, Unit* tar);
		std::pair<Unit*, Unit*> getTargetDetails();
		virtual void initialize();
		virtual int getdrive();
		virtual int getthresh();
		// what
		
	
	private:

		// generic stuff
		bool inhibited;
		AgentPool* agentPool;
		int drive;
		int thresh;
		int priority;
		OffensiveTacticsManagerAgent* parent;
		GoalDescriptor* goal;

		Unit* refinery;
		bool monitorMode;

		Unit* reporter;
		Unit* target;

		int temporalFactor;
		// implementation-specific stuff, if needed
		

};




class OffensiveTactics_ScannerSweepGoalGenerator : public GoalGeneratorBase {
public:
	OffensiveTactics_ScannerSweepGoalGenerator(AgentPool* a, OffensiveTacticsManagerAgent* parent);

	// generic stuff
	virtual void inhibit();
	virtual bool instantiateGoal();
	virtual void updateDrives();
	virtual void initialize();
	virtual int getdrive();
	virtual int getthresh();
	// what


private:

	// generic stuff
	bool inhibited;
	AgentPool* agentPool;
	int drive;
	int thresh;
	int priority;
	OffensiveTacticsManagerAgent* parent;
	GoalDescriptor* goal;

	// implementation-specific stuff, if needed


};

#endif