#ifndef OFFENSIVETACTICSMANAGERAGENT_H
#define OFFENSIVETACTICSMANAGERAGENT_H
#include "GoalDescriptor.h"
#include "AgentPool.h"
#include "GoalTypes.h"
#include "SquadTacticsModel.h"
#include "OffensiveTactics_GoalGeneratorHeaders.h"
#include <vector>


class OffensiveTacticsManagerAgent : public AgentBase {
public:
	
	OffensiveTacticsManagerAgent(AgentPool* p);
	void OffensiveTacticsManagerAgent::recruitSquad(Squad* s);
	void OffensiveTacticsManagerAgent::relinquish(SquadTacticsModel* s);
	Arbitrator* OffensiveTacticsManagerAgent::getInternalArbitrator();
	void OffensiveTacticsManagerAgent::pushTargetOfOpportunity(int goal, Unit* reporter, Unit* target) ;



	virtual void updateDrives();
	virtual Arbitrator* getArbitrator() { return internalArbitrator; };



private:
	AgentPool* agentPool;
	std::vector<SquadTacticsModel*> activeSquads;
	Squad* returnPosition;
	Arbitrator* internalArbitrator;
	OffensiveTactics_LandAttackGoalGenerator* marineRushGoalGenerator;
	OffensiveTactics_GasSteal* gasStealGoalGenerator;
	OffensiveTactics_ScannerSweepGoalGenerator* scanPOIGoalGenerator;
};


#endif
