#include "OffensiveTacticsManagerAgent.h"

OffensiveTacticsManagerAgent::OffensiveTacticsManagerAgent(AgentPool* p) {
	agentPool = p;
	marineRushGoalGenerator = new OffensiveTactics_LandAttackGoalGenerator(agentPool, this);
	gasStealGoalGenerator = new OffensiveTactics_GasSteal(agentPool, this);
	scanPOIGoalGenerator = new OffensiveTactics_ScannerSweepGoalGenerator(agentPool, this);
}

void OffensiveTacticsManagerAgent::recruitSquad(Squad* s) {

}

void OffensiveTacticsManagerAgent::pushTargetOfOpportunity(int goal, Unit* reporter, Unit* target) {
	////////////////////////agentPool->writeDebugMessage("target of opportunity received");
	gasStealGoalGenerator->attachTargetDetails(goal, reporter, target);
	if(gasStealGoalGenerator->instantiateGoal()) {
			////////////////////////agentPool->writeDebugMessage("gas steal goal instantiated");
	}
}

void OffensiveTacticsManagerAgent::updateDrives() {
	/*
	for (std::vector<SquadTacticsModel*>::const_iterator it = activeSquads.begin(); it != activeSquads.end(); ++it) {
		if((*it)->executeTactics() == false) {
			relinquish(*it);
			////////////////////////agentPool->writeDebugMessage("now erasing squad");
			(*it)->setDead();
			//activeSquads.erase(it);
			////////////////////////agentPool->writeDebugMessage("done!");
			continue; // bad idea?
		}
	}
	*/

	marineRushGoalGenerator->updateDrives();

	gasStealGoalGenerator->updateDrives();

	scanPOIGoalGenerator->updateDrives();

}

void OffensiveTacticsManagerAgent::relinquish(SquadTacticsModel* m) {
	//////////////////agentPool->writeDebugMessage("attempting to relinquish squad");
	
}

Arbitrator* OffensiveTacticsManagerAgent::getInternalArbitrator() {
	return internalArbitrator;
}