#include "OffensiveTactics_GoalGeneratorHeaders.h"
#include "OffensiveTacticsManagerAgent.h"

OffensiveTactics_ScannerSweepGoalGenerator::OffensiveTactics_ScannerSweepGoalGenerator(AgentPool* a, OffensiveTacticsManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 62; // remember this
	thresh = 50;
	parent = par;
	goal = new GoalDescriptor(OFFENSE_SCANPOI, priority, 0, 0, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool OffensiveTactics_ScannerSweepGoalGenerator::instantiateGoal() {
	return agentPool->getArbitrator()->declareIntention(goal);
}

void OffensiveTactics_ScannerSweepGoalGenerator::inhibit() {

}

void OffensiveTactics_ScannerSweepGoalGenerator::initialize() {

}

void OffensiveTactics_ScannerSweepGoalGenerator::updateDrives() {
	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			if(instantiateGoal()) {
				////////////////////////agentPool->writeDebugMessage("so i want to do a marine rush!");
				drive = 0;
			}
		} else {
			InformationManagerAgent* r = (InformationManagerAgent*)agentPool->getAgent("PI");
			if(r->hasUnit(UnitTypes::Terran_Comsat_Station)) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}

	if(goal->isExecuting()) {
			drive = 0;
			goal->finish();
	}
}

int OffensiveTactics_ScannerSweepGoalGenerator::getthresh() {
	return thresh;
}

int OffensiveTactics_ScannerSweepGoalGenerator::getdrive() {
	return drive;
}
