#include "OffensiveTactics_GoalGeneratorHeaders.h"
#include "OffensiveTacticsManagerAgent.h"
#include "CrawlingBallAttack.h"

OffensiveTactics_LandAttackGoalGenerator::OffensiveTactics_LandAttackGoalGenerator(AgentPool* a, OffensiveTacticsManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 30; // remember this
	thresh = 80;
	parent = par;
	goal = new GoalDescriptor(OFFENSE_LANDATTACK, priority, 0, 0, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool OffensiveTactics_LandAttackGoalGenerator::instantiateGoal() {
	return agentPool->getArbitrator()->declareIntention(goal);
}

void OffensiveTactics_LandAttackGoalGenerator::inhibit() {

}

void OffensiveTactics_LandAttackGoalGenerator::initialize() {

}

void OffensiveTactics_LandAttackGoalGenerator::updateDrives() {




	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			if(instantiateGoal()) {
				//////////////agentPool->writeDebugMessage("so i want to do a marine rush!");
				drive = 0;
			}
		} else {

			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
			//if(i->hasUnit(UnitTypes::Terran_Barracks) && i->hasUnit(UnitTypes::Terran_Factory) && i->hasUnit(UnitTypes::Terran_Academy)) {
				if(drive < thresh) {
					drive++;
				}
			//}
		}
	}

	if(goal->isExecuting()) {
		int alive = 0;
		for(unsigned int i = 0; i < goal->getSquadMonitorTarget()->getSquad()->getUnits().size(); i++) {
			Unit* m = goal->getSquadMonitorTarget()->getSquad()->getUnitAt(i);
			if(m->getHitPoints() > 0 && (m->getType() == UnitTypes::Terran_Siege_Tank_Siege_Mode || m->getType() == UnitTypes::Terran_Siege_Tank_Tank_Mode || m->getType() == UnitTypes::Terran_Marine || m->getType() == UnitTypes::Terran_Goliath || m->getType() == UnitTypes::Terran_Firebat|| m->getType() == UnitTypes::Terran_Vulture|| m->getType() == UnitTypes::Terran_Battlecruiser)) {
				alive++;
				//////////agentPool->writeDebugMessage("alive");
			}
		}


		if(alive <= 3) {
			//////////agentPool->writeDebugMessage("SQUAD IS WIPED OUT!");
			//////Broodwar->sendText("squad wiped out...?");
			goal->finish();
			drive = 0;
		}
	}
}

int OffensiveTactics_LandAttackGoalGenerator::getthresh() {
	return thresh;
}

int OffensiveTactics_LandAttackGoalGenerator::getdrive() {
	return drive;
}
