#include "OffensiveTactics_GoalGeneratorHeaders.h"
#include "OffensiveTacticsManagerAgent.h"

OffensiveTactics_GasSteal::OffensiveTactics_GasSteal(AgentPool* a, OffensiveTacticsManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 32; // remember this
	thresh = 1;
	parent = par;
	goal = new GoalDescriptor(OFFENSE_GASSTEAL, priority, 100, 0, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
	target = NULL;
	reporter = NULL;
	refinery = NULL;
	monitorMode = false;
	temporalFactor = 0;
}

bool OffensiveTactics_GasSteal::instantiateGoal() {
	return agentPool->getArbitrator()->declareIntention(goal);
}

void OffensiveTactics_GasSteal::inhibit() {

}

void OffensiveTactics_GasSteal::initialize() {

}

void OffensiveTactics_GasSteal::attachTargetDetails(int tac, Unit* rep, Unit* tar) {
	reporter = rep;
	target = tar;
	std::pair<Unit*,Unit*> i;
	i.first = rep;
	i.second = tar;
	//////////////////////////agentPool->writeDebugMessage("reporter:");
	//////////////////////////agentPool->writeDebugMessage(rep->getType().getName().c_str());
	//////////////////////////agentPool->writeDebugMessage("target:");
	//////////////////////////agentPool->writeDebugMessage(tar->getType().getName().c_str());
	goal->setTargetInformation(i);
}

std::pair<Unit*, Unit*> OffensiveTactics_GasSteal::getTargetDetails() {
	std::pair<Unit*, Unit*> out;
		out.first = reporter;
		out.second = target;
	return out;
}

void OffensiveTactics_GasSteal::updateDrives() {
	//////////////////////////agentPool->writeDebugMessage("gs drive");
	if(goal->isExecuting()) {
		BWAPI::Unit* worker = reporter;
		std::pair<Unit*, Unit*> g = goal->getTargetInformation();
		TilePosition q = g.second->getTilePosition();
		Broodwar->drawBox(CoordinateType::Map,q.x()*32,q.y()*32,q.x()*32+4*32,q.y()*32+2*32,Colors::Orange,false);
		

		if(worker->getBuildUnit() != NULL) {
			goal->relinquishResources();
			int remainingBuildTime = worker->getBuildUnit()->getRemainingBuildTime();
			
			if(worker->getBuildUnit()->getRemainingBuildTime() < 100) {
				worker->haltConstruction();
				goal->relinquishResources();
				goal->finish();
				agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
				worker->move((Position)Broodwar->self()->getStartLocation());
				drive = 0;
			}
			
	} else {

			if(worker != NULL) {
			if(!worker->isConstructing() && !worker->isMoving() && worker->getOrder() != Orders::ResetCollision) {
				goal->relinquishResources();
				goal->retry();
				//
				drive = 0;
			}
			}
		}

	}

	
}

int OffensiveTactics_GasSteal::getthresh() {
	return thresh;
}

int OffensiveTactics_GasSteal::getdrive() {
	return drive;
}
