#include "MilitaryProduction_GoalGeneratorHeaders.h"
#include "MilitaryProductionManagerAgent.h"

Military_TrainVultureGoalGenerator::Military_TrainVultureGoalGenerator(AgentPool* a, MilitaryProductionManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 10; // remember this
	thresh = 25;
	parent = par;
	temporalFactor = 0;
	goal = new GoalDescriptor(MILITARY_TRAINVULTURE, priority, 75, 0, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Military_TrainVultureGoalGenerator::instantiateGoal() {
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Military_TrainVultureGoalGenerator::inhibit() {

}

void Military_TrainVultureGoalGenerator::initialize() {

}

void Military_TrainVultureGoalGenerator::updateDrives() {

	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	if(goal->isExecuting()) {
		temporalFactor++;
		if(temporalFactor > 550) {
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			return;
		}
		if(goal->getMonitorTarget() != NULL) {
			if(goal->getMonitorTarget()->isTraining()) {
			goal->relinquishResources();
			if(goal->getMonitorTarget()->getRemainingTrainTime() < 20) {
							temporalFactor = 0;
				goal->finish();
			}
			}
		}
	}


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			if(instantiateGoal()) {
							temporalFactor = 0;
					////Broodwar->sendText("boom!!");
				drive = 0;
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

			if(i->hasUnit(UnitTypes::Terran_Factory)) {
				if(drive < thresh) {
					
					drive++;
				}
			}
		}
	}




}

int Military_TrainVultureGoalGenerator::getthresh() {
	return thresh;
}

int Military_TrainVultureGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

