#include "MilitaryProduction_GoalGeneratorHeaders.h"
#include "MilitaryProductionManagerAgent.h"

Military_TrainTankGoalGenerator::Military_TrainTankGoalGenerator(AgentPool* a, MilitaryProductionManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
				temporalFactor = 0;
	priority = 12; // remember this
	thresh = 25;
	parent = par;
	goal = new GoalDescriptor(MILITARY_TRAINTANK, priority, 150, 100, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Military_TrainTankGoalGenerator::instantiateGoal() {
		return agentPool->getArbitrator()->declareIntention(goal);
}

void Military_TrainTankGoalGenerator::inhibit() {

}

void Military_TrainTankGoalGenerator::initialize() {

}

void Military_TrainTankGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	if(goal->isExecuting()) {
		temporalFactor++;
		if(temporalFactor > 850) {
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			return;
		}
			//////agentPool->writeDebugMessage("executint tank build");
		if(goal->getMonitorTarget() != NULL){
			
			if(goal->getMonitorTarget()->isTraining()) {
			goal->relinquishResources();
		// remember to get the squad monitor target
	if(goal->getMonitorTarget()->getRemainingTrainTime() < 20) {
							temporalFactor = 0;
			goal->finish();
		}
			}
		}
	}


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			if(instantiateGoal()) {
				//////agentPool->writeDebugMessage("lets train some tanks!");
							temporalFactor = 0;
				drive = 0;
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

			if(i->hasUnit(UnitTypes::Terran_Factory)) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}




}

int Military_TrainTankGoalGenerator::getthresh() {
	return thresh;
}

int Military_TrainTankGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

