#include "MilitaryProduction_GoalGeneratorHeaders.h"
#include "MilitaryProductionManagerAgent.h"

Military_TrainScienceVesselGoalGenerator::Military_TrainScienceVesselGoalGenerator(AgentPool* a, MilitaryProductionManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 13; // remember this
	thresh = 50;
	parent = par;
				temporalFactor = 0;
	goal = new GoalDescriptor(MILITARY_TRAINSCIENCEVESSEL, priority, 100, 225, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Military_TrainScienceVesselGoalGenerator::instantiateGoal() {
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Military_TrainScienceVesselGoalGenerator::inhibit() {

}

void Military_TrainScienceVesselGoalGenerator::initialize() {

}

void Military_TrainScienceVesselGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	if(goal->isExecuting()) {
		temporalFactor++;
		if(temporalFactor > 1350) {
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			return;
		}
		if(goal->getMonitorTarget() != NULL){
			
			if(goal->getMonitorTarget()->isTraining()) {
			goal->relinquishResources();

			// remember to get the squad monitor target
			if(goal->getMonitorTarget()->getRemainingTrainTime() < 20) {
							temporalFactor = 0;
				goal->finish();
				drive = 0;
			}
			}
		}
	}


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			if(instantiateGoal()) {
					temporalFactor = 0;
				drive = 0;
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

			if(i->hasUnit(UnitTypes::Terran_Science_Facility) && i->countUnitType(Terran_Science_Vessel) < 1) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}




}

int Military_TrainScienceVesselGoalGenerator::getthresh() {
	return thresh;
}

int Military_TrainScienceVesselGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

