#include "MilitaryProduction_GoalGeneratorHeaders.h"
#include "MilitaryProductionManagerAgent.h"

Military_TrainMedicGoalGenerator::Military_TrainMedicGoalGenerator(AgentPool* a, MilitaryProductionManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 9; // remember this
	thresh = 25;
	parent = par;
				temporalFactor = 0;
	goal = new GoalDescriptor(MILITARY_TRAINMEDIC, priority, 50, 25, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Military_TrainMedicGoalGenerator::instantiateGoal() {
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Military_TrainMedicGoalGenerator::inhibit() {

}

void Military_TrainMedicGoalGenerator::initialize() {

}

void Military_TrainMedicGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	if(goal->isExecuting()) {
		temporalFactor++;
		if(temporalFactor > 550) {
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			return;
		}
		if(goal->getMonitorTarget() != NULL){
			
		if(goal->getMonitorTarget()->isTraining()) {
			goal->relinquishResources();
		}
		// remember to get the squad monitor target
				if(goal->getMonitorTarget()->getRemainingTrainTime() < 20) {
								temporalFactor = 0;
			goal->finish();
			////////////////////////agentPool->writeDebugMessage("medic goal complete!");
		}
		}
	}


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			if(instantiateGoal()) {
				drive = 0;
							temporalFactor = 0;
				////////////////////////agentPool->writeDebugMessage("instantiated medic goal");
			} else {
				////////////////////////agentPool->writeDebugMessage("couldnt instantiate medic goal");
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
			float numMarines = (float)i->countUnitType(UnitTypes::Terran_Marine);
			float numMedics = (float)i->countUnitType(UnitTypes::Terran_Medic);


			if(numMarines == 0) {

			} else {
				if(i->hasUnit(UnitTypes::Terran_Refinery) && i->hasUnit(UnitTypes::Terran_Academy) && i->hasUnit(UnitTypes::Terran_Barracks)) {
					if(drive < thresh) {
						drive++;
					}
				}
			}
		}
	}
}

int Military_TrainMedicGoalGenerator::getthresh() {
	return thresh;
}

int Military_TrainMedicGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

