#include "MilitaryProduction_GoalGeneratorHeaders.h"
#include "MilitaryProductionManagerAgent.h"

Military_TrainMarineGoalGenerator::Military_TrainMarineGoalGenerator(AgentPool* a, MilitaryProductionManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 10; // remember this
	thresh = 25;
	parent = par;
				temporalFactor = 0;
	goal = new GoalDescriptor(MILITARY_TRAINMARINE, priority, 50, 0, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Military_TrainMarineGoalGenerator::instantiateGoal() {
		return agentPool->getArbitrator()->declareIntention(goal);
}

void Military_TrainMarineGoalGenerator::inhibit() {

}

void Military_TrainMarineGoalGenerator::initialize() {

}

void Military_TrainMarineGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	if(goal->isExecuting()) {
		temporalFactor++;
		if(temporalFactor > 470) {
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			return;
		}
		if(goal->getMonitorTarget() != NULL) {	
			if(goal->getMonitorTarget()->isTraining()) {
			goal->relinquishResources();
				if(goal->getMonitorTarget()->getRemainingTrainTime() < 20) {
								temporalFactor = 0;
			goal->finish();
		}
			}

		}
	}


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			if(instantiateGoal()) {
					temporalFactor = 0;
				drive = 0;
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

			if(i->hasUnit(UnitTypes::Terran_Barracks)) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}




}

int Military_TrainMarineGoalGenerator::getthresh() {
	return thresh;
}

int Military_TrainMarineGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

