#include "MilitaryProduction_GoalGeneratorHeaders.h"
#include "MilitaryProductionManagerAgent.h"

Military_TrainGoliathGoalGenerator::Military_TrainGoliathGoalGenerator(AgentPool* a, MilitaryProductionManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	temporalFactor = 0;
	priority = 11; // remember this
	thresh = 25;
	parent = par;
	goal = new GoalDescriptor(MILITARY_TRAINGOLIATH, priority, 150, 100, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Military_TrainGoliathGoalGenerator::instantiateGoal() {
		return agentPool->getArbitrator()->declareIntention(goal);
}

void Military_TrainGoliathGoalGenerator::inhibit() {

}

void Military_TrainGoliathGoalGenerator::initialize() {

}

void Military_TrainGoliathGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	if(goal->isExecuting()) {
		temporalFactor++;
		if(temporalFactor > 1000) {
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			return;
		}
		if(goal->getMonitorTarget() != NULL) {
			
			if(goal->getMonitorTarget()->isTraining()) {
			goal->relinquishResources();
				if(goal->getMonitorTarget()->getRemainingTrainTime() < 20) {
							temporalFactor = 0;
							goal->finish();
						}
			}
		}
	}


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			if(instantiateGoal()) {
							temporalFactor = 0;
				//////////////////////////agentPool->writeDebugMessage("lets train some marines!");
				drive = 0;
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

			if(i->hasUnit(UnitTypes::Terran_Factory) && i->hasUnit(UnitTypes::Terran_Armory)) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}
}

int Military_TrainGoliathGoalGenerator::getthresh() {
	return thresh;
}

int Military_TrainGoliathGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

