#include "MilitaryProduction_GoalGeneratorHeaders.h"
#include "MilitaryProductionManagerAgent.h"

Military_TrainFlyerGoalGenerator::Military_TrainFlyerGoalGenerator(AgentPool* a, MilitaryProductionManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 12; // remember this
	thresh = 25;
				temporalFactor = 0;
	parent = par;
	goal = new GoalDescriptor(MILITARY_TRAINFLYER, priority, 150, 100, agentPool->getArbitrator()->getBidManager());
		agentPool->registerGoal(goal);
}

bool Military_TrainFlyerGoalGenerator::instantiateGoal() {
		return agentPool->getArbitrator()->declareIntention(goal);
}

void Military_TrainFlyerGoalGenerator::inhibit() {

}

void Military_TrainFlyerGoalGenerator::initialize() {

}

void Military_TrainFlyerGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	if(goal->isExecuting()) {
		temporalFactor++;
		if(temporalFactor > 850) {
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			return;
		}
		if(goal->getMonitorTarget() != NULL && goal->getMonitorTarget()->isTraining()) {
			goal->relinquishResources();
		
		// remember to get the squad monitor target
				if(goal->getMonitorTarget()->getRemainingTrainTime() < 20) {
								temporalFactor = 0;
			goal->finish();
		}
		//if(!goal->getMonitorTarget()->isTraining()) {
			//////////////////////////agentPool->writeDebugMessage("not enough supply, can't train marine...");
		//		goal->relinquishResources();
		//	goal->finish();
		
		//}
		} else {
						temporalFactor = 0;
			goal->relinquishResources();
			goal->retry();
		}
	}


	if(!goal->accepted() && !goal->isExecuting()) {
		InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

		UnitType best = i->getReccomendedFlyerType();
		//////////////////agentPool->writeDebugMessage("best flyer is:");
		//////////////////agentPool->writeDebugMessage(best.getName());

		if(drive >= thresh) {
			goal->modifyPrice(best.mineralPrice(), best.gasPrice());
			if(instantiateGoal()) {
							temporalFactor = 0;
				//////////////////////////agentPool->writeDebugMessage("lets train some marines!");
				drive = 0;
			}
		} else {

			if(i->hasUnit(UnitTypes::Terran_Control_Tower) && i->hasUnit(UnitTypes::Terran_Starport) && !i->hasUnitUnderConstruction(UnitTypes::Terran_Starport) && i->countUnitType(UnitTypes::Terran_Wraith) < 10 && i->countUnitType(UnitTypes::Terran_Valkyrie) < 6) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}




}

int Military_TrainFlyerGoalGenerator::getthresh() {
	return thresh;
}

int Military_TrainFlyerGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

