#include "MilitaryProduction_GoalGeneratorHeaders.h"
#include "MilitaryProductionManagerAgent.h"

Military_TrainFireBatGoalGenerator::Military_TrainFireBatGoalGenerator(AgentPool* a, MilitaryProductionManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 10; // remember this
	thresh = 25;
				temporalFactor = 0;
	parent = par;
	goal = new GoalDescriptor(MILITARY_TRAINFIREBAT, priority, 50, 25, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Military_TrainFireBatGoalGenerator::instantiateGoal() {
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Military_TrainFireBatGoalGenerator::inhibit() {

}

void Military_TrainFireBatGoalGenerator::initialize() {

}

void Military_TrainFireBatGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	if(goal->isExecuting()) {
		temporalFactor++;
		if(temporalFactor > 460) {
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			return;
		}
		if(goal->getMonitorTarget() != NULL && goal->getMonitorTarget()->isTraining()) {
			goal->relinquishResources();
				if(goal->getMonitorTarget()->getRemainingTrainTime() < 20) {
								temporalFactor = 0;
				goal->finish();
			}

		}
	}


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			if(instantiateGoal()) {
				////////////////////////agentPool->writeDebugMessage("lets train some marines!");
							temporalFactor = 0;
				drive = 0;
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

			if(i->hasUnit(UnitTypes::Terran_Barracks) && i->hasUnit(UnitTypes::Terran_Academy)) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}




}

int Military_TrainFireBatGoalGenerator::getthresh() {
	return thresh;
}

int Military_TrainFireBatGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

