#include "MilitaryProduction_GoalGeneratorHeaders.h"
#include "MilitaryProductionManagerAgent.h"

Military_TrainDropShipGoalGenerator::Military_TrainDropShipGoalGenerator(AgentPool* a, MilitaryProductionManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 10; // remember this
	thresh = 11;
	parent = par;
	temporalFactor = 0;
	goal = new GoalDescriptor(MILITARY_TRAINDROPSHIP, priority, 100, 100, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Military_TrainDropShipGoalGenerator::instantiateGoal() {
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Military_TrainDropShipGoalGenerator::inhibit() {

}

void Military_TrainDropShipGoalGenerator::initialize() {

}

void Military_TrainDropShipGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	if(goal->isExecuting()) {
		temporalFactor++;
		if(temporalFactor > 850) {
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			return;
		}
		if(goal->getMonitorTarget() != NULL && goal->getMonitorTarget()->isTraining()) {
			goal->relinquishResources();

			// remember to get the squad monitor target
			if(goal->getMonitorTarget()->getRemainingTrainTime() < 20) {
						temporalFactor = 0;
				goal->finish();
			}
			//if(!goal->getMonitorTarget()->isTraining()) {
			//////////////////////////agentPool->writeDebugMessage("not enough supply, can't train marine...");
			//		goal->relinquishResources();
			//	goal->finish();

			//}
		} else {
			goal->relinquishResources();
					temporalFactor = 0;
			goal->retry();
		}
	}


	if(!goal->accepted() && !goal->isExecuting()) {
		InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");


		//////////////////agentPool->writeDebugMessage("best flyer is:");
		//////////////////agentPool->writeDebugMessage(best.getName());

		if(drive >= thresh) {
		if(instantiateGoal()) {
					temporalFactor = 0;
				//////////////////////////agentPool->writeDebugMessage("lets train some marines!");
				drive = 0;
			}
		} else {

			if(i->hasUnit(UnitTypes::Terran_Control_Tower) && i->hasUnit(UnitTypes::Terran_Starport) && !i->hasUnitUnderConstruction(UnitTypes::Terran_Starport) && i->countUnitType(UnitTypes::Terran_Dropship) < 1) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}




}

int Military_TrainDropShipGoalGenerator::getthresh() {
	return thresh;
}

int Military_TrainDropShipGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

