#include "MilitaryProduction_GoalGeneratorHeaders.h"
#include "MilitaryProductionManagerAgent.h"

Military_TrainBattlecruiserGoalGenerator::Military_TrainBattlecruiserGoalGenerator(AgentPool* a, MilitaryProductionManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 15; // remember this
	thresh = 25;
	parent = par;
	goal = new GoalDescriptor(MILITARY_TRAINBATTLECRUISER, priority, 400, 300, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
}

bool Military_TrainBattlecruiserGoalGenerator::instantiateGoal() {
	return agentPool->getArbitrator()->declareIntention(goal);
}

void Military_TrainBattlecruiserGoalGenerator::inhibit() {

}

void Military_TrainBattlecruiserGoalGenerator::initialize() {

}

void Military_TrainBattlecruiserGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	if(goal->isExecuting()) {
		if(goal->getMonitorTarget() != NULL && goal->getMonitorTarget()->isTraining()) {
			goal->relinquishResources();
				if(goal->getMonitorTarget()->getRemainingTrainTime() < 20) {
				goal->finish();
			}

		}
	}


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			if(instantiateGoal()) {
				////////////////////////agentPool->writeDebugMessage("lets train some marines!");
				drive = 0;
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");

			if(i->hasUnit(UnitTypes::Terran_Starport) && i->hasUnit(UnitTypes::Terran_Control_Tower) && i->hasUnit(UnitTypes::Terran_Science_Facility) && i->hasUnit(UnitTypes::Terran_Science_Facility)) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}




}

int Military_TrainBattlecruiserGoalGenerator::getthresh() {
	return thresh;
}

int Military_TrainBattlecruiserGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

