#include "MilitaryStructure_GoalGeneratorHeaders.h"
#include "MilitaryStructureManagerAgent.h"

Military_BuildScienceFacilityGoalGenerator::Military_BuildScienceFacilityGoalGenerator(AgentPool* a, MilitaryStructureManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 8; // remember this
	thresh = 25;
	parent = par;
	temporalFactor = 0;
	goal = new GoalDescriptor(MILITARY_BUILDSCIENCEFACILITY, priority, 100, 150, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
		temporalFactor = 0;
}

bool Military_BuildScienceFacilityGoalGenerator::instantiateGoal() {
	//////////////////////////agentPool->writeDebugMessage("intending to build academy");
	return agentPool->getArbitrator()->declareIntention(goal);
	return false;
}

void Military_BuildScienceFacilityGoalGenerator::inhibit() {

}

void Military_BuildScienceFacilityGoalGenerator::initialize() {

}

void Military_BuildScienceFacilityGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	if(goal->isExecuting()) {
			BWAPI::Unit* worker = goal->getMonitorTarget();
		temporalFactor++;
		if(temporalFactor > 1300) {
			////////////////agentPool->writeDebugMessage("construction of: ");
			////////////////agentPool->writeDebugMessage(goal->getNaturalName());	
			////////////////agentPool->writeDebugMessage("--- abandoning due to time constraints");	
			worker->stop();
			agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			
			return;
		}
	
	//	if(worker->isConstructing()) //{
			if(worker->getBuildUnit() != NULL) {
				goal->relinquishResources();
				int remainingBuildTime = worker->getBuildUnit()->getRemainingBuildTime();
				if(worker->getBuildUnit()->isCompleted()) {
					//////////////////////////agentPool->writeDebugMessage("academy done!");
					goal->finish();
					//goal->accept();
					agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
					drive = 0;
						temporalFactor = 0;
				}
			//}
			}  else {
				if(worker != NULL) {
					if(!worker->isConstructing() && !worker->isMoving() && worker->getOrder() != Orders::ResetCollision) {
						goal->relinquishResources();
						goal->retry();
						agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
						temporalFactor = 0;
						drive = 0;
					}
				}
			}
		}
	


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			//////////////////////////agentPool->writeDebugMessage("i'd like to build an academy!!");
			if(instantiateGoal()) {
				//////////////////////////agentPool->writeDebugMessage("it's queued!");
				drive = 0;
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
			//////////////////////////agentPool->writeDebugMessage("considering academy condition!");
			if((i->hasUnit(UnitTypes::Terran_Barracks) && i->hasUnit(UnitTypes::Terran_Starport) && !i->hasUnit(UnitTypes::Terran_Science_Facility) && !i->hasUnitUnderConstruction(UnitTypes::Terran_Science_Facility))) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}
}

int Military_BuildScienceFacilityGoalGenerator::getthresh() {
	return thresh;
}

int Military_BuildScienceFacilityGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

