#include "MilitaryStructure_GoalGeneratorHeaders.h"
#include "MilitaryStructureManagerAgent.h"

Military_BuildFactoryGoalGenerator::Military_BuildFactoryGoalGenerator(AgentPool* a, MilitaryStructureManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 9; // remember this
	thresh = 30;
	parent = par;
	temporalFactor = 0;
	goal = new GoalDescriptor(MILITARY_BUILDFACTORY, priority, 200, 100, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
		temporalFactor = 0;
}

bool Military_BuildFactoryGoalGenerator::instantiateGoal() {
	return agentPool->getArbitrator()->declareIntention(goal);
	return false;
}

void Military_BuildFactoryGoalGenerator::inhibit() {

}

void Military_BuildFactoryGoalGenerator::initialize() {

}

void Military_BuildFactoryGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	if(goal->isExecuting()) {
			BWAPI::Unit* worker = goal->getMonitorTarget();
		temporalFactor++;
		if(temporalFactor > 1600) {
			////////////////agentPool->writeDebugMessage("construction of: ");
			////////////////agentPool->writeDebugMessage(goal->getNaturalName());	
			////////////////agentPool->writeDebugMessage("--- abandoning due to time constraints");
			worker->stop();
			agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
			
			return;
		}
	
		//if(worker->isConstructing()) {
			if(worker->getBuildUnit() != NULL) { 
				goal->relinquishResources();
				int remainingBuildTime = worker->getBuildUnit()->getRemainingBuildTime();
				if(worker->getBuildUnit()->isCompleted()) {
					//////////////////////////agentPool->writeDebugMessage("factory done!");
					goal->finish();
						//		//goal->accept();
					agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
					drive = 0;
					temporalFactor = 0;
				}
			//}
			}  else {
				if(worker != NULL) {
					if(!worker->isConstructing() && !worker->isMoving() && worker->getOrder() != Orders::ResetCollision) {
						goal->relinquishResources();
						goal->retry();
						agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
						temporalFactor = 0;
						drive = 0;
					}
				}
			}

	}


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			//////////////////////////agentPool->writeDebugMessage("i'd like to build an factory!!");
			if(instantiateGoal()) {
				//////////////////////////agentPool->writeDebugMessage("it's queued!");
				drive = 0;
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
			if((i->hasUnit(UnitTypes::Terran_Barracks) && (!i->hasUnit(UnitTypes::Terran_Factory) || (i->countUnitType(UnitTypes::Terran_Factory) <= 2 && Broodwar->enemy()->getRace() != Races::Zerg) || (i->countUnitType(UnitTypes::Terran_Factory) < 4 && Broodwar->enemy()->getRace() == Races::Protoss && i->getBases().size() >= 3)))) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}
}

int Military_BuildFactoryGoalGenerator::getthresh() {
	return thresh;
}

int Military_BuildFactoryGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

