#include "MilitaryStructure_GoalGeneratorHeaders.h"
#include "MilitaryStructureManagerAgent.h"
#include "ResourceManagerAgent.h"

Military_BuildEngineeringBayGoalGenerator::Military_BuildEngineeringBayGoalGenerator(AgentPool* a, MilitaryStructureManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 8; // remember this
	thresh = 50;
	parent = par;
	temporalFactor = 0;
	goal = new GoalDescriptor(MILITARY_BUILDENGINEERINGBAY, priority, 125, 0, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
		temporalFactor = 0;
}

bool Military_BuildEngineeringBayGoalGenerator::instantiateGoal() {
		return agentPool->getArbitrator()->declareIntention(goal);
	return false;
}

void Military_BuildEngineeringBayGoalGenerator::inhibit() {

}

void Military_BuildEngineeringBayGoalGenerator::initialize() {

}

void Military_BuildEngineeringBayGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

		if(goal->isExecuting()) {
				BWAPI::Unit* worker = goal->getMonitorTarget();
			temporalFactor++;
			if(temporalFactor > 1600) {	
				worker->stop();
				agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
				goal->relinquishResources();
				goal->finish();
				temporalFactor = 0;
				drive = 0;
				
				return;
			}
	
		//if(worker->isConstructing()) {
			if(worker->getBuildUnit() != NULL) {
			goal->relinquishResources();
			int remainingBuildTime = worker->getBuildUnit()->getRemainingBuildTime();
			if(worker->getBuildUnit()->isCompleted()) {
				//////////////////////////agentPool->writeDebugMessage("engineering bay done!");
				goal->finish();
							//goal->accept();
						agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
						drive = 0;
						temporalFactor = 0;
			}
			//}
			} else {
				if(worker != NULL) {
					if(!worker->isConstructing() && !worker->isMoving() && worker->getOrder() != Orders::ResetCollision) {
						goal->relinquishResources();
						goal->retry();
						agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
						temporalFactor = 0;
						drive = 0;
					}
				}
			}

	}


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			//////////////////////////agentPool->writeDebugMessage("i'd like to build an engineering bay!!");
			if(instantiateGoal()) {
				//////////////////////////agentPool->writeDebugMessage("it's queued!");
				drive = 0;
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
				ResourceManagerAgent* r = (ResourceManagerAgent*)agentPool->getAgent("R");
				//////////////////////////agentPool->writeDebugMessage("considering engineering bay");
				if(i->hasUnit(UnitTypes::Terran_Factory) && i->hasUnit(UnitTypes::Terran_Barracks) && i->hasUnit(UnitTypes::Terran_Refinery) && !i->hasUnit(UnitTypes::Terran_Engineering_Bay) && !i->hasUnitUnderConstruction(UnitTypes::Terran_Engineering_Bay)) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}
}

int Military_BuildEngineeringBayGoalGenerator::getthresh() {
	return thresh;
}

int Military_BuildEngineeringBayGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

