#include "MilitaryStructure_GoalGeneratorHeaders.h"
#include "MilitaryStructureManagerAgent.h"

Military_BuildBarracksGoalGenerator::Military_BuildBarracksGoalGenerator(AgentPool* a, MilitaryStructureManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 10; // remember this
	thresh = 45;
	parent = par;
	temporalFactor = 0;
	goal = new GoalDescriptor(MILITARY_BUILDBARRACKS, priority, 150, 0, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
	temporalFactor = 0;
}

bool Military_BuildBarracksGoalGenerator::instantiateGoal() {
	InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
	//if(Broodwar->self()->supplyUsed()/2 >= 8 && Broodwar->self()->supplyUsed()/2 <= 12 && !im->hasUnit(UnitTypes::Terran_Barracks) && !im->hasUnitUnderConstruction(UnitTypes::Terran_Barracks)) {
		return agentPool->getArbitrator()->declareIntention(goal);
//	}
	return false;
}

void Military_BuildBarracksGoalGenerator::inhibit() {

}

void Military_BuildBarracksGoalGenerator::initialize() {

}

void Military_BuildBarracksGoalGenerator::updateDrives() {
		////////////agentPool->writeDebugMessage("seeing if this is inhibired");
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

	if(goal->isExecuting()) {
		////////////agentPool->writeDebugMessage("is executing ");
			BWAPI::Unit* worker = goal->getMonitorTarget();
		temporalFactor++;
		if(temporalFactor > 1800) {
			worker->stop();
			agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
			goal->relinquishResources();
			goal->finish();
			temporalFactor = 0;
			drive = 0;
		
			return;
		}
	
			if(worker->getBuildUnit() != NULL) {
				int remainingBuildTime = worker->getBuildUnit()->getRemainingBuildTime();
				goal->relinquishResources();
				if(worker->getBuildUnit()->isCompleted() || remainingBuildTime < 50) {
					goal->finish();
					agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
					drive = 0;
					temporalFactor = 0;
				}
			} else {
				if(worker != NULL) {
					if(!worker->isConstructing() && !worker->isMoving() && worker->getOrder() != Orders::ResetCollision) {
							////////////agentPool->writeDebugMessage("retrying goal");
							agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
						goal->relinquishResources();
						goal->retry();
						
							temporalFactor = 0;
						drive = 0;
					}
				}
			}
	} else {
			////////////agentPool->writeDebugMessage("not even executing");
	}


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			if(instantiateGoal()) {
					temporalFactor = 0;
				drive = 0;
			}
		} else {
			InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("PI");
			if(Broodwar->self()->supplyUsed()/2 >= 5 && 
				((!im->hasUnit(UnitTypes::Terran_Barracks) && !im->hasUnitUnderConstruction(UnitTypes::Terran_Barracks)) || 
				(im->countUnitType(UnitTypes::Terran_Barracks) < 2 && (Broodwar->enemy()->getRace() == Races::Zerg || Broodwar->enemy()->getRace() == Races::Terran)))) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}
}

int Military_BuildBarracksGoalGenerator::getthresh() {
	return thresh;
}

int Military_BuildBarracksGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

