#include "MilitaryStructure_GoalGeneratorHeaders.h"
#include "MilitaryStructureManagerAgent.h"

Military_BuildArmoryGoalGenerator::Military_BuildArmoryGoalGenerator(AgentPool* a, MilitaryStructureManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 7; // remember this
	thresh = 20;
	parent = par;
		temporalFactor = 0;
		goal = new GoalDescriptor(MILITARY_BUILDARMORY, priority, 100, 50, agentPool->getArbitrator()->getBidManager());
		agentPool->registerGoal(goal);
			temporalFactor = 0;
}

bool Military_BuildArmoryGoalGenerator::instantiateGoal() {
		return agentPool->getArbitrator()->declareIntention(goal);
	return false;
}

void Military_BuildArmoryGoalGenerator::inhibit() {

}

void Military_BuildArmoryGoalGenerator::initialize() {

}

void Military_BuildArmoryGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

		if(goal->isExecuting()) {
				BWAPI::Unit* worker = goal->getMonitorTarget();
			temporalFactor++;
			if(temporalFactor > 1800) {
				////////////////agentPool->writeDebugMessage("construction of: ");
				////////////////agentPool->writeDebugMessage(goal->getNaturalName());	
				////////////////agentPool->writeDebugMessage("--- abandoning due to time constraints");	
				goal->relinquishResources();
				goal->finish();
				temporalFactor = 0;
				drive = 0;
				worker->stop();
				agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
				return;
			}

		//if(worker->isConstructing()) {
			if(worker->getBuildUnit() != NULL) {
			goal->relinquishResources();
			int remainingBuildTime = worker->getBuildUnit()->getRemainingBuildTime();
			if(worker->getBuildUnit()->isCompleted()) {
					////////////////////////agentPool->writeDebugMessage("factory done!");
				goal->finish();
				//goal->accept();
				agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
				drive = 0;
					temporalFactor = 0;
			}
			//}
			} else {
				if(worker != NULL) {
					if(!worker->isConstructing() && !worker->isMoving() && worker->getOrder() != Orders::ResetCollision) {
						goal->relinquishResources();
						goal->retry();
						agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
						temporalFactor = 0;
						drive = 0;
					}
				}
			}
		} 


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			////////////////////////agentPool->writeDebugMessage("i'd like to build an factory!!");
			if(instantiateGoal()) {
				////////////////////////agentPool->writeDebugMessage("it's queued!");
				drive = 0;
					temporalFactor = 0;
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
			if(i->hasUnit(UnitTypes::Terran_Barracks) && !i->hasUnitUnderConstruction(UnitTypes::Terran_Armory) && (i->getBases().size() >= 1 && i->countUnitType(UnitTypes::Terran_Armory) < 2 && i->hasUnit(UnitTypes::Terran_Factory))) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}
}

int Military_BuildArmoryGoalGenerator::getthresh() {
	return thresh;
}

int Military_BuildArmoryGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

