#include "MilitaryStructure_GoalGeneratorHeaders.h"
#include "MilitaryStructureManagerAgent.h"

Military_BuildAcademyGoalGenerator::Military_BuildAcademyGoalGenerator(AgentPool* a, MilitaryStructureManagerAgent* par) {
	inhibited = false;
	agentPool = a;
	drive = 0;
	priority = 4; // remember this
	thresh = 75;
	parent = par;
	temporalFactor = 0;
	goal = new GoalDescriptor(MILITARY_BUILDACADEMY, priority, 150, 0, agentPool->getArbitrator()->getBidManager());
	agentPool->registerGoal(goal);
		temporalFactor = 0;
}

bool Military_BuildAcademyGoalGenerator::instantiateGoal() {
	//////////////////////////agentPool->writeDebugMessage("intending to build academy");
		return agentPool->getArbitrator()->declareIntention(goal);
	return false;
}

void Military_BuildAcademyGoalGenerator::inhibit() {

}

void Military_BuildAcademyGoalGenerator::initialize() {

}

void Military_BuildAcademyGoalGenerator::updateDrives() {
	if(goal->getInhibitionStatus() == true && !goal->isExecuting()) return;

		if(goal->isExecuting()) {
				BWAPI::Unit* worker = goal->getMonitorTarget();
			temporalFactor++;
			if(temporalFactor > 1600) {
				////////////agentPool->writeDebugMessage("construction of: ");
				////////////agentPool->writeDebugMessage(goal->getNaturalName());	
				////////////agentPool->writeDebugMessage("--- abandoning due to time constraints");
				worker->stop();
						agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
				goal->relinquishResources();
				goal->finish();
				temporalFactor = 0;
				drive = 0;
						////////////agentPool->writeDebugMessage("moving home!");	
			
					////////////agentPool->writeDebugMessage("wheeeee");	
				return;
			}

		//if(worker->isConstructing()) {
			if(worker->getBuildUnit() != NULL) {
			goal->relinquishResources();
			int remainingBuildTime = worker->getBuildUnit()->getRemainingBuildTime();
			if(worker->getBuildUnit()->isCompleted()) {
					//////////////////////////agentPool->writeDebugMessage("academy done!");
				goal->finish();
					//goal->accept();
					agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
				drive = 0;
					temporalFactor = 0;
			}
		//	}
			}  else {
				if(worker != NULL) {
					if(!worker->isConstructing() && !worker->isMoving() && worker->getOrder() != Orders::ResetCollision) {
						goal->relinquishResources();
						goal->retry();
						agentPool->getSquads()->getSquadByName("workers")->addUnit(worker);
						temporalFactor = 0;
						drive = 0;
					}
				}
			}
	}


	if(!goal->accepted() && !goal->isExecuting()) {
		if(drive >= thresh) {
			//////////////////////////agentPool->writeDebugMessage("i'd like to build an academy!!");
			if(instantiateGoal()) {
				//////////////////////////agentPool->writeDebugMessage("it's queued!");
				drive = 0;
				temporalFactor = 0;
			}
		} else {
			InformationManagerAgent* i = (InformationManagerAgent*)agentPool->getAgent("PI");
			//////////////////////////agentPool->writeDebugMessage("considering academy condition!");
			if((i->hasUnit(UnitTypes::Terran_Barracks) || i->hasUnitUnderConstruction(UnitTypes::Terran_Barracks)) && 
				(!i->hasUnit(UnitTypes::Terran_Academy) && !i->hasUnitUnderConstruction(UnitTypes::Terran_Academy))) {
				if(drive < thresh) {
					drive++;
				}
			}
		}
	}
}

int Military_BuildAcademyGoalGenerator::getthresh() {
	return thresh;
}

int Military_BuildAcademyGoalGenerator::getdrive() {
	return drive;
}

/*

Implementation-specific functions.

*/

