#ifndef MILSTRUCTMANAGENT_H
#define MILSTRUCTMANAGENT_H
#include <vector>
#include "AgentBase.h"
#include "MineralModel.h"
#include "GasModel.h"
#include "ConstructionAgent.h"
#include "MilitaryStructure_GoalGeneratorHeaders.h"
#include "GoalTypes.h"

class AgentPool;
//class SquadPool;

class MilitaryStructureManagerAgent : public AgentBase {
public:
	MilitaryStructureManagerAgent::MilitaryStructureManagerAgent(AgentPool* p);
	MilitaryStructureManagerAgent::MilitaryStructureManagerAgent();
	void MilitaryStructureManagerAgent::initialize();
	Arbitrator* MilitaryStructureManagerAgent::getInternalArbitrator();
	virtual void updateDrives();
	virtual Arbitrator* getArbitrator() { return internalArbitrator; };


private:
	AgentPool* agentPool;
	Arbitrator* internalArbitrator;
	Military_BuildBarracksGoalGenerator* buildBarracksGoal;
	Military_BuildAcademyGoalGenerator* buildAcademyGoal;
	Military_BuildStarportGoalGenerator* buildStarportGoal;
	Military_BuildFactoryGoalGenerator* buildFactoryGoal;
	Military_BuildArmoryGoalGenerator* buildArmoryGoal;
	Military_BuildEngineeringBayGoalGenerator* buildEngineeringBayGoal;
	Military_BuildScienceFacilityGoalGenerator* buildScienceFacilityGoal;
	// Goal generators


};
#endif