#include "MilitaryStructureManagerAgent.h"
#include "AgentPool.h"
//#include "SquadPool.h"
MilitaryStructureManagerAgent::MilitaryStructureManagerAgent(AgentPool* p) {
	agentPool = p;
	internalArbitrator = new Arbitrator(p);



	buildBarracksGoal = new Military_BuildBarracksGoalGenerator(p, this);
	buildAcademyGoal = new Military_BuildAcademyGoalGenerator(p, this);
	buildStarportGoal = new Military_BuildStarportGoalGenerator(p, this);
	buildFactoryGoal = new Military_BuildFactoryGoalGenerator(p, this);
	buildArmoryGoal = new Military_BuildArmoryGoalGenerator(p, this);
	buildEngineeringBayGoal = new Military_BuildEngineeringBayGoalGenerator(p, this);
	buildScienceFacilityGoal = new Military_BuildScienceFacilityGoalGenerator(p,this);




	initialize();
}

MilitaryStructureManagerAgent::MilitaryStructureManagerAgent() {
	
}


void MilitaryStructureManagerAgent::initialize() {
	////////////////////////agentPool->writeDebugMessage("\t\t military manager attempting to initialize");
}

void MilitaryStructureManagerAgent::updateDrives() {
	////////////agentPool->writeDebugMessage("a");
	buildBarracksGoal->updateDrives();
	////////////agentPool->writeDebugMessage("b");
	buildAcademyGoal->updateDrives();
	////////////agentPool->writeDebugMessage("c");
	buildEngineeringBayGoal->updateDrives();
	////////////agentPool->writeDebugMessage("d");
	buildFactoryGoal->updateDrives();
	////////////agentPool->writeDebugMessage("e");
	buildStarportGoal->updateDrives();
	////////////agentPool->writeDebugMessage("f");
	buildArmoryGoal->updateDrives();
	
	buildScienceFacilityGoal->updateDrives();
	////////////agentPool->writeDebugMessage("g");
}

Arbitrator* MilitaryStructureManagerAgent::getInternalArbitrator() {
	return internalArbitrator;
}
