#ifndef MILPRODMANAGEMENT_H
#define MILPRODMANAGEMENT_H
#include <vector>
#include "AgentBase.h"
#include "MineralModel.h"
#include "GasModel.h"
#include "ConstructionAgent.h"
#include "MilitaryProduction_GoalGeneratorHeaders.h"
#include "GoalTypes.h"

class AgentPool;
//class SquadPool;

class MilitaryProductionManagerAgent : public AgentBase {
public:
	MilitaryProductionManagerAgent::MilitaryProductionManagerAgent(AgentPool* p);
	MilitaryProductionManagerAgent::MilitaryProductionManagerAgent();
	void MilitaryProductionManagerAgent::initialize();
	Arbitrator* MilitaryProductionManagerAgent::getInternalArbitrator();
	virtual void updateDrives();
	virtual Arbitrator* getArbitrator() { return internalArbitrator; };
	void registerProductionOrder(UnitOrder u);
	void determineActiveProductionGoals();
	void receiveAlert(UnitType t, bool buildOrDead, int id);
	void cleanUp();
	void advanceProductionProcess();

private:
	AgentPool* agentPool;
	Arbitrator* internalArbitrator;
	Military_TrainMarineGoalGenerator* trainMarineGoal;
	Military_TrainMedicGoalGenerator* trainMedicGoal;
	Military_TrainTankGoalGenerator* trainTankGoal;
	Military_TrainFlyerGoalGenerator* trainWraithGoal;
	Military_TrainScienceVesselGoalGenerator* trainScienceVesselGoal;
	Military_TrainDropShipGoalGenerator* trainDropShipGoal;
	Military_TrainFireBatGoalGenerator* trainFireBatGoal;
	Military_TrainVultureGoalGenerator* trainVultureGoal;
	Military_TrainBattlecruiserGoalGenerator* trainBattleCruiserGoal;
	Military_TrainGoliathGoalGenerator* trainGoliathGoal;
	// Goal generators
	std::vector<std::pair<UnitType,int>> activeOrders;
	SquadReccomender* sqr;
};
#endif