#include "MilitaryProductionManagerAgent.h"
#include "AgentPool.h"
#include "SquadReccomender.h"
#include "SquadManagerAgent.h"

MilitaryProductionManagerAgent::MilitaryProductionManagerAgent(AgentPool* p ) {
	agentPool = p;
	internalArbitrator = new Arbitrator(p);
	trainMarineGoal = new Military_TrainMarineGoalGenerator(p, this);
	trainFireBatGoal = new Military_TrainFireBatGoalGenerator(p, this);
	trainMedicGoal =  new Military_TrainMedicGoalGenerator(p, this);
	trainTankGoal = new Military_TrainTankGoalGenerator(p,this);
	trainWraithGoal = new Military_TrainFlyerGoalGenerator(p,this);
	trainScienceVesselGoal = new Military_TrainScienceVesselGoalGenerator(p,this);
	trainDropShipGoal = new Military_TrainDropShipGoalGenerator(p,this);
	trainVultureGoal = new Military_TrainVultureGoalGenerator(p,this);
	trainGoliathGoal = new Military_TrainGoliathGoalGenerator(p,this);
	trainBattleCruiserGoal = new Military_TrainBattlecruiserGoalGenerator(p,this);
	sqr = agentPool->getSquadReccomender();
	registerProductionOrder(sqr->reccomendGroundSquad());

	initialize();
}

	void MilitaryProductionManagerAgent::advanceProductionProcess() {
		sqr->advanceStage();
		registerProductionOrder(sqr->reccomendGroundSquad());
	}

MilitaryProductionManagerAgent::MilitaryProductionManagerAgent() {
	
}

	void MilitaryProductionManagerAgent::receiveAlert(UnitType t, bool buildOrDead, int id) {
		if(t == Terran_Siege_Tank_Siege_Mode) {
			t = Terran_Siege_Tank_Tank_Mode;
		}
	if(!activeOrders.empty()) {
		for (unsigned int i = activeOrders.size(); i-- > 0; ) {
			if(activeOrders.at(i).first == t) { //here'st he issue

				// true means this unit has been built, false means it has been killed
				/// so we need to replace it if it wasn't in a squad
				if(buildOrDead) {
					if(activeOrders.at(i).second > 0){
						activeOrders.at(i).second = activeOrders.at(i).second - 1;
						break;
					}
				}
			}
		}
		}

		UnitOrder u = sqr->reccomendGroundSquad();
		if(!buildOrDead) {
				//Broodwar->sendText("alerted to a ded guy!");
			for(int i = 0; i < u.getOrder().size(); i++) {
				std::pair<UnitType, int> req = u.getOrder().at(i);

					if(req.first == t) {
							//Broodwar->sendText("gotcha!");
						SquadManagerAgent* sq = (SquadManagerAgent*)agentPool->getAgent("SQ");
						if(!sq->isUnitInSquads(id)) {
							//Broodwar->sendText("adding replacement");
							std::pair<UnitType, int> replacement;
								replacement.first = t;


								replacement.second = 1;
								activeOrders.push_back(replacement);
							break;
						}
					}
			}




		}


	}

void MilitaryProductionManagerAgent::registerProductionOrder(UnitOrder u) {
	for(unsigned int i = 0; i < u.getOrder().size(); i++) {
		std::pair<UnitType, int> o = u.getOrder().at(i);
		if(o.second > 0) {
			o.second = (int)(o.second * 1.4); // try to order a little bit more than what we need
			activeOrders.push_back(o);
		}
	}
}

	void MilitaryProductionManagerAgent::determineActiveProductionGoals() {
		agentPool->getRegisteredGoal(MILITARY_TRAINDROPSHIP)->setInhibit(false);
		agentPool->getRegisteredGoal(MILITARY_TRAINMARINE)->setInhibit(true);
		agentPool->getRegisteredGoal(MILITARY_TRAINFIREBAT)->setInhibit(true);
		agentPool->getRegisteredGoal(MILITARY_TRAINMEDIC)->setInhibit(true);
		agentPool->getRegisteredGoal(MILITARY_TRAINTANK)->setInhibit(true);
		agentPool->getRegisteredGoal(MILITARY_TRAINVULTURE)->setInhibit(true);
		agentPool->getRegisteredGoal(MILITARY_TRAINFLYER)->setInhibit(false);
		agentPool->getRegisteredGoal(MILITARY_TRAINGOLIATH)->setInhibit(true);
		agentPool->getRegisteredGoal(MILITARY_TRAINBATTLECRUISER)->setInhibit(true);
		agentPool->getRegisteredGoal(MILITARY_TRAINSCIENCEVESSEL)->setInhibit(true);


			for (unsigned int i = activeOrders.size(); i-- > 0; ) {
				if(activeOrders.at(i).second > 0) {
				if(activeOrders.at(i).first == UnitTypes::Terran_Marine) {
					agentPool->getRegisteredGoal(MILITARY_TRAINMARINE)->setInhibit(false);
				}	
				if(activeOrders.at(i).first == UnitTypes::Terran_Firebat) {
					agentPool->getRegisteredGoal(MILITARY_TRAINFIREBAT)->setInhibit(false);
				}
				if(activeOrders.at(i).first == UnitTypes::Terran_Medic) {
					agentPool->getRegisteredGoal(MILITARY_TRAINMEDIC)->setInhibit(false);
				}
				if(activeOrders.at(i).first == UnitTypes::Terran_Siege_Tank_Tank_Mode || activeOrders.at(i).first == UnitTypes::Terran_Siege_Tank_Siege_Mode) {
					agentPool->getRegisteredGoal(MILITARY_TRAINTANK)->setInhibit(false);
				}
				if(activeOrders.at(i).first == UnitTypes::Terran_Science_Vessel) {
					agentPool->getRegisteredGoal(MILITARY_TRAINSCIENCEVESSEL)->setInhibit(false);
				}
				if(activeOrders.at(i).first == UnitTypes::Terran_Vulture) {
					agentPool->getRegisteredGoal(MILITARY_TRAINVULTURE)->setInhibit(false);
				}
				if(activeOrders.at(i).first == UnitTypes::Terran_Battlecruiser) {
					agentPool->getRegisteredGoal(MILITARY_TRAINBATTLECRUISER)->setInhibit(false);
				}
				if(activeOrders.at(i).first == UnitTypes::Terran_Goliath) {
					agentPool->getRegisteredGoal(MILITARY_TRAINGOLIATH)->setInhibit(false);
				}
			}
			}
	}

void MilitaryProductionManagerAgent::initialize() {

}

void MilitaryProductionManagerAgent::updateDrives() {

	cleanUp();
	determineActiveProductionGoals();	
	trainTankGoal->updateDrives();
	trainVultureGoal->updateDrives();
	trainGoliathGoal->updateDrives();

	trainMarineGoal->updateDrives();
	trainMedicGoal->updateDrives();
	trainFireBatGoal->updateDrives();

	trainWraithGoal->updateDrives();
	trainScienceVesselGoal->updateDrives();
	trainDropShipGoal->updateDrives();

	trainBattleCruiserGoal->updateDrives();


}

Arbitrator* MilitaryProductionManagerAgent::getInternalArbitrator() {
	return internalArbitrator;
}

void MilitaryProductionManagerAgent::cleanUp() {
	for (unsigned int j = activeOrders.size(); j-- > 0; ) {
		if(activeOrders.at(j).second <= 0 || activeOrders.at(j).first == UnitTypes::Terran_SCV) {
			activeOrders.erase(activeOrders.begin()+j);
			break;
		}
	}
}
