#ifndef MICROTACTICSMODEL_H
#define MICROTACTICSMODEL_H
#include <vector>
#include "BWAPI.h"
#include "TargetFitnessCalculator.h"

using namespace BWAPI;

class MicroTacticsModel {

public:
		~MicroTacticsModel() {
		}
		virtual bool MicroTacticsModel::executeTactics() = 0;
		virtual Unit* getUnit() = 0;
		virtual UnitType getKnownType() = 0;
		virtual void setMovementLag(int l) = 0;
		virtual void move(Position p) = 0;

private:
	Unit* element;
	Unit* followTarget;
	int initialMovementLag;
	int movementLagTimer;
	UnitType knownType;
};



#endif