#include "MedicMicroTactics.h"
#include "CrawlingBallAttack.h"
#include <cmath>


MedicMicroTactics::MedicMicroTactics(Unit* u, CrawlingBallAttack* s) {
	element = u;
	closestTarget = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	movementLagTimer = 0;
	initialMovementLag = 0;
	followTarget = NULL;
	squadTactics = s;
	knownType = u->getType();
}

UnitType MedicMicroTactics::getKnownType() {
	return knownType;
}
MedicMicroTactics::MedicMicroTactics(Unit* u, int movementLag) {
	element = u;
	closestTarget = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	movementLagTimer = movementLag;
	initialMovementLag = movementLag;
	followTarget = NULL;
	knownType = u->getType();
}


void MedicMicroTactics::setMovementLag(int l) {
	initialMovementLag = l;
}

void MedicMicroTactics::move(Position p) {
	// INSTEAD of moving to p, move to the best location you can see from here to p
	int initPopSize = 64;
	int initPopVariance = 128;
	std::vector<Position> population;
	std::vector<Position> solution;

	// generate population
	for(int i = 0; i < initPopSize; i++) {
		Position newPosition = p;
		int newX = rand()%initPopVariance;
		int newY = rand()%initPopVariance;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		newPosition = Position(p.x()+newX, p.y()+newY);
		population.push_back(newPosition);
	}

	// find the best member
	Position bestPosition = element->getPosition();
	for(int i = 0; i < initPopSize; i++) {
		Position n = population.at(i);
		if((n.getApproxDistance(p) < bestPosition.getApproxDistance(p)) && element->hasPath(n)) {
			bestPosition = n;
			solution.push_back(n);
		}
	}
 	//for(unsigned int i = 0; i < solution.size(); i++) {
 	//	Broodwar->drawDot(CoordinateType::Map, solution.at(i).x(), solution.at(i).y(), Colors::Blue);
 //	}
	if(!solution.empty() && !population.empty()) {
		if(rand()%100 > 75) {
			random_shuffle(population.begin(), population.end());
			element->move(population.at(0));
		} else {
			random_shuffle(solution.begin(), solution.end());
			element->move(solution.at(0));
		}
	} else {
		////////Broodwar->sendText("HOLY BALLLSSS - medic");
	}
}

bool MedicMicroTactics::executeTactics() {
	if(Broodwar->getFrameCount()%8==0) {
	std::set<Unit*> stuffInRange = element->getUnitsInRadius(200);
	int nearByAllies = 0;
	int bestFitness = 0;
	for (std::set<BWAPI::Unit*>::const_iterator it = stuffInRange.begin(); it != stuffInRange.end(); ++it)
	{
		if((*it) != element && (*it)->getPlayer()->getID() == Broodwar->self()->getID() && !(*it)->isBeingHealed() && (*it)->getType().isOrganic() && !(*it)->getType().isNeutral() && !(*it)->getType().isBuilding() && (*it)->getHitPoints() < (*it)->getType().maxHitPoints()) {
			nearByAllies++;	
			if(closestTarget == NULL) {
				closestTarget = *it;
			} else {
				int targetFitness = (*it)->getHitPoints() + element->getDistance(*it);
				if(targetFitness < closestTarget->getHitPoints()) {
					bestFitness = targetFitness;
					closestTarget = *it;
				}
			}
		}
	}
	if(nearByAllies > 0) {
		if(element->getOrder() != Orders::MedicHeal1 && element->getOrder() != Orders::MedicHeal2) {
			element->useTech(TechTypes::Healing, closestTarget);
			//Broodwar->printf("Medic healing [%d] ", closestTarget->getType().getName());
			return true;
		}
	} 
	


	std::vector<MicroTacticsModel*> marines = squadTactics->getSubTeam(UnitTypes::Terran_Marine);
	std::vector<MicroTacticsModel*> firebats = squadTactics->getSubTeam(UnitTypes::Terran_Firebat);
	marines.insert(marines.begin(), firebats.begin(), firebats.end());
	if(!marines.empty()) {
		Position tankLine;

		int avgX = 0;
		int avgY = 0;
		int siegedTanks = 0;
		// find where the tanks are
		for(unsigned int i = 0; i < marines.size(); i++) {
			if(marines.at(i)->getUnit()->getHitPoints() > 0) {
				avgX = avgX + marines.at(i)->getUnit()->getPosition().x();
				avgY = avgY + marines.at(i)->getUnit()->getPosition().y();
				siegedTanks++;
			}
		}
		//if(siegedTanks == 0) {

		//} else {
		// find the average position
		if(siegedTanks != 0) {
			avgX = avgX/siegedTanks;
			avgY = avgY/siegedTanks;
			tankLine = Position(avgX, avgY);

			// now... we might already be AT the tank line
			// in which case, we just want to shoot stuff...
			// but if we're far away, lets move towards it
			if(element->getPosition().getDistance(tankLine) > 200) {
				element->attack(tankLine);
				return true;
			} else {
		
				if(nearByAllies > 0) {
						element->useTech(TechTypes::Healing, closestTarget);
						return true;
				} 
			}
		}
	}
	}
	return false;
}

Unit* MedicMicroTactics::getUnit() {
	return element;
}

