#include "MarineSupportSquadron.h"
#include "Squad.h"
#include "AgentPool.h"
#include "MicroTacticsModel.h"
#include "MarineMicroTactics.h"
#include "SiegeTankMicroTactics.h"

MarineSupportSquadron::MarineSupportSquadron(Squad* m, AgentPool* p) {
	dead = false;
	element = m;
	agentPool = p;
	for(unsigned int i = 0; i < element->getUnits().size(); i++) {
		assignUnit(element->getUnitAt(i));
	}
	m->attachTacticsImplementation(this);
}

void MarineSupportSquadron::assignUnit(Unit* u) {
	if(u->getType() == BWAPI::UnitTypes::Terran_Marine || u->getType() == BWAPI::UnitTypes::Terran_Firebat) {
		//Broodwar->sendText("marine tactics attached");
		unitTactics.push_back(new MarineMicroTactics(u, 0));
	}	
	if(u->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode) {
		//Broodwar->sendText("tank tactics attached");
		unitTactics.push_back(new SiegeTankMicroTactics(u, 0));
	}	
}

void MarineSupportSquadron::receiveAlert(Unit* t) {
	assignUnit(t);
}

std::vector<MicroTacticsModel*> MarineSupportSquadron::getSubTeam(UnitType t) {
	std::vector<MicroTacticsModel*> subSquad;
	for(unsigned int i = 0; i < unitTactics.size(); i++) {
		MicroTacticsModel* u = unitTactics.at(i);
		if(u->getUnit()->getType() == t) {
			subSquad.push_back(u);
		}	
	}
	return subSquad;
}

bool MarineSupportSquadron::execute() {
	if(!unitTactics.empty()) {
		// firstly... is the squad dead?
		bool microTacticsExecuted = false;
		for(unsigned int i = 0; i < unitTactics.size(); i++) {
			MicroTacticsModel* m = unitTactics.at(i);

			// ignore units under construction 
			if(!m->getUnit()->isCompleted()) {
				continue;
			}

			// firstly, if this guy is dead, get rid of him
			if(m->getUnit()->getHitPoints() <= 0) {
				continue;
			}
			////////////////////////agentPool->writeDebugMessage("seeing which tactics to do...");
			if(m->executeTactics() == true) {
				microTacticsExecuted = true;
			}
		}
	}
	return true;
}

void MarineSupportSquadron::removeUnit( Unit* ut )
{
	for(unsigned int i = 0; i < unitTactics.size(); i++) {
		MicroTacticsModel* u = unitTactics.at(i);
		if(u->getUnit() == ut) {
				////agentPool->writeDebugMessage("rem unit");
			unitTactics.erase(unitTactics.begin()+i);
		}	
	}
}
