#ifndef MARINEMICRO_H
#define MARINEMICRO_H
#include "MicroTacticsModel.h"

class CrawlingBallAttack;


class MarineMicroTactics : public MicroTacticsModel {

public:
	MarineMicroTactics::MarineMicroTactics(Unit* u, CrawlingBallAttack* s);
	MarineMicroTactics::MarineMicroTactics(Unit* u, int movementLag);
	virtual bool MicroTacticsModel::executeTactics();
	virtual Unit* getUnit();
	virtual void setMovementLag(int l);
	virtual void move(Position p);
	virtual UnitType getKnownType();
private:
	Unit* element;
	Unit* closestEnemy;
	TargetFitnessCalculator* fitnessCalculator;
	Position targetLoc;
	int wait;
	int initialMovementLag;
	int movementLagTimer;
	Unit* followTarget;
	Unit* lastTarget;
	CrawlingBallAttack* squadTactics;
	UnitType knownType;

	int teleporterClickCount;
	Unit* firstClicked;
};


#endif