#include "MarineMicroTactics.h"
#include "CrawlingBallAttack.h"
#include <cmath>


MarineMicroTactics::MarineMicroTactics(Unit* u, CrawlingBallAttack* s) {
	element = u;
	closestEnemy = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	wait = 0;
	movementLagTimer = 0;
	initialMovementLag = 0;
	lastTarget = NULL;
	squadTactics = s;
	knownType = u->getType();
}

MarineMicroTactics::MarineMicroTactics(Unit* u, int movementLag) {
	element = u;
	closestEnemy = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	wait = 0;
	movementLagTimer = movementLag;
	initialMovementLag = movementLag;
	lastTarget = NULL;
	knownType = u->getType();
	squadTactics = NULL;
}
UnitType MarineMicroTactics::getKnownType() {
	return knownType;
}

void MarineMicroTactics::move(Position p) {
	int initPopSize = 64;
	int initPopVariance = 128;
	std::vector<Position> population;
	std::vector<Position> solution;
	std::set<Unit*> stuffInRange = element->getUnitsInRadius(element->getType().sightRange());
	std::vector<Unit*> dangerFilter;
	for (std::set<BWAPI::Unit*>::const_iterator it = stuffInRange.begin(); it != stuffInRange.end(); ++it)
	{
		Unit* target = *it;
		if(target->getPlayer() != Broodwar->self() && !target->getType().isNeutral()) {
		if(target->getType() == UnitTypes::Zerg_Sunken_Colony || target->getType() == UnitTypes::Terran_Bunker  || target->getType() == UnitTypes::Protoss_Photon_Cannon) {
			dangerFilter.push_back(target);
		}
		}
	}
	// generate population
	for(int i = 0; i < initPopSize; i++) {
		Position newPosition = element->getPosition();
		int newX = rand()%initPopVariance;
		int newY = rand()%initPopVariance;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		newPosition = Position(element->getPosition().x()+newX, element->getPosition().y()+newY);

			population.push_back(newPosition);

	}

	// find the best member
	Position bestPosition = element->getPosition();
	int bestFitness = 90000;
	for(int i = 0; i < initPopSize; i++) {
		Position n = population.at(i);
		int threatOfMove = 0;
		for(unsigned int k = 0; k < dangerFilter.size(); k++) {
			int distance = n.getDistance(dangerFilter.at(k)->getPosition());
			int minRange = dangerFilter.at(k)->getType().groundWeapon().minRange();
			int maxRange = dangerFilter.at(k)->getType().groundWeapon().maxRange();
			if(minRange < distance && maxRange >= distance) {
					threatOfMove+=250;
			}
		}
		
		int fitness = n.getApproxDistance(p) + threatOfMove;
		if(fitness < bestFitness && element->hasPath(n)) 
		{
					bestPosition = n;
					bestFitness = fitness;
					solution.push_back(n);
			}

	}


			element->move(bestPosition);


}

	void MarineMicroTactics::setMovementLag(int l) {
		initialMovementLag = l;
		movementLagTimer = l;
	}

bool MarineMicroTactics::executeTactics() {

	if(element->isLoaded() && !element->isAttacking()) {
		if(element->getTransport()->getType() == UnitTypes::Terran_Bunker && !element->getTransport()->isUnderAttack()) {
			element->getTransport()->unload(element);
		}
	}
	std::set<Unit*> stuffInRange = element->getUnitsInWeaponRange(element->getType().groundWeapon());
	int nearByEnemies = 0;
	int bestFitness = 0;
	int z = 0;
	Unit* nz = NULL;
	for (std::set<BWAPI::Unit*>::const_iterator it = stuffInRange.begin(); it != stuffInRange.end(); ++it)
	{
		if((*it)->getPlayer()->getID() != Broodwar->self()->getID() && (*it)->getHitPoints() > 0 && !(*it)->getType().isNeutral() && !(*it)->getType().isSpecialBuilding() && (*it)->getType() != UnitTypes::Zerg_Larva && (*it)->getType() != UnitTypes::Zerg_Egg) {
			nearByEnemies++;	
			if(closestEnemy == NULL || closestEnemy->getHitPoints() <= 0) {
				closestEnemy = *it;
			} else {
					int targetFitness = fitnessCalculator->calculateFitness(*it);
				if(targetFitness > fitnessCalculator->calculateFitness(closestEnemy)) {
					bestFitness = targetFitness;
					closestEnemy = *it;
				}
			}
			if((*it)->getType() == Protoss_Zealot && (*it)->getDistance(element) <= 96) {
				z++;
				if(nz == NULL) {
					nz = *it;
				} else{
					if(element->getDistance(*it) < element->getDistance(nz)) {
						nz = *it;
					}
				}
			}
		}
	}

	
	if(nz != NULL && element->getHitPoints() < element->getType().maxHitPoints()) {
		int tx = nz->getPosition().x();
		int ty = nz->getPosition().y();
		int mx = element->getPosition().x();
		int my = element->getPosition().y();

		int nx = 0;
		int ny = 0;

		// if the enemy is to my right
		if(tx >= mx) {
			// move far left
			nx = (tx-350);
		} else {
			// move far right
			nx = tx+350;
		}

		// if the enemy is below me
		if(ty >= my) {
			// move up
			ny = (ty-350);
		} else {
			// move down
			ny = (ty+350);
		}
		////Broodwar->sendText("bailing!");
		move(Position(nx,ny));
		return true;
	}
	



	if(squadTactics != NULL) {
	std::vector<MicroTacticsModel*> tanks = squadTactics->getSubTeam(UnitTypes::Terran_Siege_Tank_Siege_Mode);
		if(!tanks.empty()) {
			Position tankLine;

			int avgX = 0;
			int avgY = 0;
			int siegedTanks = 0;
			// find where the tanks are
			for(unsigned int i = 0; i < tanks.size(); i++) {
				if(tanks.at(i)->getUnit()->isSieged()) {
				avgX = avgX + tanks.at(i)->getUnit()->getPosition().x();
				avgY = avgY + tanks.at(i)->getUnit()->getPosition().y();
				siegedTanks++;
				}
			}
			//if(siegedTanks == 0) {

			//} else {
			// find the average position
			if(siegedTanks != 0) {
			avgX = avgX/siegedTanks;
			avgY = avgY/siegedTanks;
			tankLine = Position(avgX, avgY);
			
			// now... we might already be AT the tank line
			// in which case, we just want to shoot stuff...
			// but if we're far away, lets move towards it
			if(element->getPosition().getDistance(tankLine) > 150) {
				if(!element->isMoving()) {
						element->attack(tankLine);
					}
				return true;
			} else {
				if(nearByEnemies > 0) {
					if(Broodwar->self()->hasResearched(TechTypes::Stim_Packs)) {
						if(!element->isStimmed()) {
							if(element->useTech(TechTypes::Stim_Packs)) {
								////////Broodwar->sendText("popped stim packs!");
							}
						}
					}
					if(element->getGroundWeaponCooldown() <= 0 || closestEnemy != element->getOrderTarget()) {
						if(closestEnemy->getHitPoints() > 0) {
							element->attack(closestEnemy);
							return true;
						}
					}
				} else {
					if(element->getPosition().getDistance(Position(tankLine)) > 50) {
						move(tankLine);
						return true;
					}
				}
			}
		}
			
		}
}










	
		if(nearByEnemies != 0) {
			// shoot stuff!
			if(Broodwar->self()->hasResearched(TechTypes::Stim_Packs)) {
				if(!element->isStimmed()) {
					if(element->useTech(TechTypes::Stim_Packs)) {
						////////Broodwar->sendText("popped stim packs!");
					}
				}
			}
			if(element->getGroundWeaponCooldown() <= 0) {
				if(!element->isAttacking()) {
					element->attack(closestEnemy);
				}
			}
			lastTarget = closestEnemy;
			return true;
	} else {
		return false;
	}


}

Unit* MarineMicroTactics::getUnit() {
	return element;
}

