#ifndef INFORMATIONMANAGERAGENT_H
#define INFORMATIONMANAGERAGENT_H
#include "GoalDescriptor.h"
#include "AgentPool.h"
#include "GoalTypes.h"
#include "UnitModel.h"
#include "RectangleArray.h"
#include "BaseModel.h"
#include "BWTA.h"
#include "StrategyEstimator.h"

#include <vector>
#include <stack>

using namespace BWTA;

class SquadManagerAgent;
class ThreatAwarePathFinder;

class InformationManagerAgent : public AgentBase {
public:

	InformationManagerAgent(AgentPool* p);
	void alert(Unit* u);
	void destroyed(Unit* u);
	void InformationManagerAgent::printUnits();
	void InformationManagerAgent::printBuildings();

	std::vector<Unit*> InformationManagerAgent::getUnitsThatProduce(Unit* u);
	std::vector<Unit*> InformationManagerAgent::getUnitsOfType(UnitType u);
	std::vector<Unit*> InformationManagerAgent::getUnitsOfType(std::pair<UnitType,UnitType> u);
	std::vector<Unit*> InformationManagerAgent::getBuildingsOfType(UnitType u);
	int InformationManagerAgent::countUnitType(UnitType t);

	bool InformationManagerAgent::hasUnit(UnitType t);
	bool InformationManagerAgent::hasActiveRefineryAtBase();

	bool InformationManagerAgent::hasUnitUnderConstruction(UnitType t);
	void InformationManagerAgent::addBase(TilePosition p, Unit* u);
	BaseModel* InformationManagerAgent::getBase(TilePosition p);
	bool InformationManagerAgent::canPerformScannerSweep(InformationManagerAgent* im);
	void InformationManagerAgent::scanPointsOfInterest(InformationManagerAgent* im);
	Position InformationManagerAgent::findHighestConcentrationOf(UnitType t);
	std::vector<Unit*> InformationManagerAgent::findLocalObstructions();
	UnitType InformationManagerAgent::getReccomendedFlyerType();
	TilePosition InformationManagerAgent::locateWeakestPerceivedBase();
	Unit* InformationManagerAgent::selectNewMainBase();

	std::vector<UnitModel*> InformationManagerAgent::getKnownBuildings();
	std::vector<UnitModel*> InformationManagerAgent::getKnownBuildingsAroundPoint(Position p, int radius);
	std::vector<UnitModel*> InformationManagerAgent::getKnownUnitsAroundPoint(Position p, int radius);
	std::vector<BaseModel*> InformationManagerAgent::getBases();
	BaseLocation* InformationManagerAgent::findClosestExpansionPoint(Unit* tester);
	BaseLocation* InformationManagerAgent::findClosestExpansionPoint();
	bool InformationManagerAgent::hasUnit(Unit* t);
	bool InformationManagerAgent::baseIsTaken(Unit* u);
	bool InformationManagerAgent::baseIsTaken(TilePosition u);

	std::vector<UnitModel*> InformationManagerAgent::evaluateThreatAt(Position p);
	int InformationManagerAgent::getAirThreat(Position p);
	std::pair<int,int> InformationManagerAgent::getStrategyEstimate();

	virtual void updateDrives();
	virtual Arbitrator* getArbitrator() { return NULL; };
	ThreatAwarePathFinder* pathFinder;

AgentPool* agentPool;
private:
	
	std::vector<UnitModel*> unitSet;
	std::vector<UnitModel*> buildingSet;

	bool InformationManagerAgent::updateKnowledge(Unit* u);
	bool InformationManagerAgent::inferKnowledge(Unit* u);
	bool  InformationManagerAgent::isProducedBy(Unit* u, UnitType t);
	Util::RectangleArray<int> map;

	std::vector<BaseModel*> bases;
	std::stack<Unit*> pending;
	bool pendingLock;
	bool initialized;
	StrategyEstimator* strategyEstimator;
	TargetFitnessCalculator* tf;

};


#endif
