#include "InformationManagerAgent.h"
#include "SquadManagerAgent.h"
#include "ThreatAwarePathfinder.h"
#include "TrainingManagerAgent.h"
#include "ScienceVesselMicroTactics.h"
#include "MilitaryProductionManagerAgent.h"
#include "TargetFitnessCalculator.h"
//ScienceVesselMicroTactics* sv = NULL;

InformationManagerAgent::InformationManagerAgent(AgentPool* p) {
	agentPool = p;
	map.resize(BWAPI::Broodwar->mapWidth(), BWAPI::Broodwar->mapHeight());
	initialized = false;
	strategyEstimator = new StrategyEstimator();
	pathFinder = new ThreatAwarePathFinder((InformationManagerAgent*)agentPool->getAgent("PI"), agentPool);
	tf = new TargetFitnessCalculator();
}

// this is mainly used to find groups of workers
// it works since they're all always clumped up in big groups
// can't make the same assumptions for other unit types, so
// probably wouldn't work so well for anything else.
Position InformationManagerAgent::findHighestConcentrationOf(UnitType t) {
	std::vector<Unit*> subset = getUnitsOfType(t);
	////////////////agentPool->writeDebugMessage(("looking for highest concentration of: "));
	////////////////agentPool->writeDebugMessage((t.getName()));

	if(subset.empty()) {
		////////////////agentPool->writeDebugMessage(("didnt find any "));
		return (Position)Broodwar->self()->getStartLocation();
	}
	// pick a random unit

	Unit* bestSoFar = NULL;
	int bestNbrsSoFar = 0;
	int attempts = 0;

	while(attempts < 100) {
		// pick a random unit we know about
		Unit* u = subset.at(rand()%subset.size());
		int nbrs = 0;
		//////////////////////////agentPool->writeDebugMessage(("attempt"));
		// see how many neighbours we think it might have
		for(unsigned int i = 0; i < subset.size(); i++) {
			if(subset.at(i)->getPosition().getDistance(u->getPosition()) < 500) {
				nbrs++;
			}
		}

		// if this guy has more neighbours than anyone else, pick him
		if(nbrs > bestNbrsSoFar) {
			bestNbrsSoFar = nbrs;
			bestSoFar = u;
		}

		// then move on to someone else
		attempts++;
	}
	////////////////agentPool->writeDebugMessage(("all done"));
	if(bestSoFar == NULL || bestNbrsSoFar == 0) {
		return agentPool->getCurrentPrimaryBase()->getPosition();
	} else {
		//	////////////////////////agentPool->writeDebugMessage(("sending back"));
		//////////////////////////agentPool->writeDebugMessage((bestSoFar->getLastKnownPosition().x()));
		//////////////////////////agentPool->writeDebugMessage((bestSoFar->getLastKnownPosition().y()));
		return bestSoFar->getPosition();
	}
	return agentPool->getCurrentPrimaryBase()->getPosition();
}

void InformationManagerAgent::alert(Unit* u) {
	pending.push(u);

	// also, if this is one of our units, alert the squad manager
	if(u->getPlayer() == Broodwar->self()) {
		SquadManagerAgent* s = (SquadManagerAgent*)agentPool->getAgent("SQ");
		s->alertNewUnit(u);	
		//if(u->getType() == Terran_Science_Vessel && sv == NULL) {
			//sv = new ScienceVesselMicroTactics(u,this);
		//}
	}
}

TilePosition InformationManagerAgent::locateWeakestPerceivedBase() {
	int bestFitness = -90000;
	BaseModel* bestBase = NULL;
	for(int i = 0; i < bases.size(); i++) {
			if(bestBase == NULL) {
					bestBase = bases.at(i);
					bestFitness = tf->calculateBaseFitness(bases.at(i), this);
			} else {
				int curFitness = tf->calculateBaseFitness(bases.at(i), this);
				if(curFitness > bestFitness) {
					bestFitness = curFitness;
					bestBase = bases.at(i);
				}
			}
	}
	if(bestBase != NULL) {
		return (TilePosition)bestBase->getPosition();
	} else {
		return TilePosition(0,0);
	}

}

	UnitType InformationManagerAgent::getReccomendedFlyerType() {
		
		////////////////////////agentPool->writeDebugMessage("--getting reccomended flyer: --");

		UnitType best = BWAPI::UnitTypes::Terran_Wraith;
			TrainingManagerAgent* t = (TrainingManagerAgent*)agentPool->getAgent("T");
			InformationManagerAgent* ei = (InformationManagerAgent*)agentPool->getAgent("EI");
			if(t->canBeTrained(BWAPI::UnitTypes::Terran_Valkyrie)) {
				int airBiasScore = ei->getStrategyEstimate().first;
				BWAPI::Race r = BWAPI::Broodwar->enemy()->getRace();
				////////////////////////agentPool->writeDebugMessage("-- enemy is a : ");
				////////////////////////agentPool->writeDebugMessage(r.getName());

				if(r == Races::Terran) {
					if(airBiasScore > 1100) best = BWAPI::UnitTypes::Terran_Valkyrie;
				}
				if(r == Races::Zerg) {
					if(airBiasScore > 900) best = BWAPI::UnitTypes::Terran_Valkyrie;
				}				
				if(r == Races::Protoss) {
					if(airBiasScore > 1500) best = BWAPI::UnitTypes::Terran_Valkyrie;
				}
				////////////////////////agentPool->writeDebugMessage("and their air score is: ");
				////////////////////////agentPool->writeDebugMessage(airBiasScore);

		} else {
			////////////////////////agentPool->writeDebugMessage("-- can't train valkyries anyway --");

			}
		return best;
	}

std::pair<int,int> InformationManagerAgent::getStrategyEstimate() {
	std::pair<int,int> strat;
	strat.first = 0;
	strat.second = 0;
	if(!buildingSet.empty() && !unitSet.empty()) {
		std::pair<int,int> buildings = strategyEstimator->calculateBuildingStrategyBias(buildingSet);
		std::pair<int,int> units = strategyEstimator->calculateUnitStrategyBias(unitSet);
		strat.first = buildings.first+units.first;
		strat.second = buildings.second+units.second;
	}
	return strat;
}

BaseLocation* InformationManagerAgent::findClosestExpansionPoint() {
	return findClosestExpansionPoint(NULL);
}

std::vector<Unit*> InformationManagerAgent::findLocalObstructions() {
	std::vector<Unit*> obstructions;
	std::vector<BaseModel*> b = getBases();
	bool obstructionPresent = false;
	Unit* obstruction = NULL;
	for(unsigned int i = 0; i < b.size(); i++) {
		std::set<BWAPI::Unit*> nbrs = Broodwar->getUnitsInRadius(b.at(i)->getPosition(), 1500);
		obstructionPresent = false;
		for (std::set<BWAPI::Unit*>::const_iterator it = nbrs.begin(); it != nbrs.end(); ++it) {
			if((*it)->getType().isResourceContainer()) {
				if((*it)->getResources() == 0 || (*it)->getResources() == 249) {
					obstructions.push_back(*it);
				}
			}
		}
	}
	return obstructions;
}

BaseLocation* InformationManagerAgent::findClosestExpansionPoint(Unit* tester) {
	// goal: look at the most recent base, and find
	// the expansion point closest to it
	if(bases.empty()) {
		//////////////////////////////agentPool->writeDebugMessage("bases empty");
		return NULL;
	}
	BaseModel* currentBase = bases.at(bases.size()-1);
	TilePosition closest = TilePosition(9000,9000);
	BaseLocation* nextBase = NULL;
	BaseLocation* bestBase = NULL;
	double bestDistance = 90000;
	std::set<BaseLocation*> allBases = BWTA::getBaseLocations();
	InformationManagerAgent* eim = (InformationManagerAgent*)agentPool->getAgent("EI");

	for(std::set<BaseLocation*>::const_iterator i = allBases.begin(); i != allBases.end(); i++) {

		if(!BWTA::isConnected((*i)->getTilePosition(), Broodwar->self()->getStartLocation()) || (*i)->isIsland() || ((*i)->getGeysers().empty() && !findLocalObstructions().empty()) || eim->baseIsTaken((*i)->getTilePosition()) || baseIsTaken((*i)->getTilePosition())) {
			////////Broodwar->sendText("no geysers");
			continue;
		}

		nextBase = (*i);
		if(bestBase == NULL) {
			bestBase = nextBase;
		}
		if(nextBase->getPosition().getDistance(currentBase->getPosition()) < 800) {
			continue;
		} else {

			double distance = 0;
			if(Broodwar->mapFileName().compare("(2)Heartbreak Ridge.scx") == 0 || Broodwar->mapFileName().compare("(4)Fortress.scx") == 0 || Broodwar->mapFileName().compare("(3)Tau Cross.scx")) {
				if(Broodwar->mapFileName().compare("(2)Heartbreak Ridge.scx")){
				currentBase = bases.at(0);
				}
				distance = nextBase->getTilePosition().getDistance((TilePosition)currentBase->getPosition());
			} else {
				distance = BWTA::getGroundDistance(nextBase->getTilePosition(), (TilePosition)currentBase->getPosition());
			}

			if(distance < bestDistance) {
				InformationManagerAgent* im = (InformationManagerAgent*)agentPool->getAgent("EI");

				if(!im->baseIsTaken(nextBase->getTilePosition())) {
					if(tester != NULL) {
						if(tester->hasPath((Position)nextBase->getTilePosition())) {
							closest = nextBase->getTilePosition();
							bestBase = nextBase;
							bestDistance = distance;
						}
					} else {
						closest = nextBase->getTilePosition();
						bestBase = nextBase;
						bestDistance = distance;
					}
				}
			}


		}
	}
	//agentPool->writeDebugMessage("best distance: ");
	//agentPool->writeDebugMessage((int)bestDistance);



	//////////////////////////////agentPool->writeDebugMessage("bases found a potential expansion");
	//////////////////////////////agentPool->writeDebugMessage("bases closest to: ");
	//////////////////////////////agentPool->writeDebugMessage(((TilePosition)currentBase->getPosition()).x());
	//////////////////////////////agentPool->writeDebugMessage(((TilePosition)currentBase->getPosition()).y());
	//////////////////////////////agentPool->writeDebugMessage("is bases at: ");
	//////////////////////////////agentPool->writeDebugMessage(closest.x());
	//////////////////////////////agentPool->writeDebugMessage(closest.y());



	return bestBase;
}

bool InformationManagerAgent::canPerformScannerSweep(InformationManagerAgent* eim) {
	if(eim->getKnownBuildings().size() == 0) {
		return false;
	}
	//////////agentPool->writeDebugMessage("looking for a comsat...");

	std::set<Unit*> myBuildings = Broodwar->self()->getUnits();
	for(std::set<Unit*>::const_iterator i = myBuildings.begin(); i != myBuildings.end(); i++) {
		Unit* cur = *i;
		if(cur->isCompleted()) {
			if(cur->getType() == UnitTypes::Terran_Command_Center) {
				if(cur->getAddon() != NULL) {
					if(cur->getAddon()->isCompleted()) {
					//////////agentPool->writeDebugMessage("yes! we have a comsat station!");
					if(cur->getAddon()->getEnergy() > 80) {
						return true;
					}
					}
				}
			}
		}
	}
	//////////////////////////agentPool->writeDebugMessage("couldn't find a comsat");
	return false;
}


void InformationManagerAgent::scanPointsOfInterest(InformationManagerAgent* eim) {
	// for now this isn't very sophisticated at all - just scan around
	// where we've seen enemy buildings in the past

	//////////////////////////agentPool->writeDebugMessage("looking for a scan target");
	std::vector<UnitModel*> buildings = eim->getKnownBuildings();
	if(buildings.empty()) {
		return;
	}
	//////////////agentPool->writeDebugMessage("got them");
	int scanFocus = rand()%(buildings.size());
	//////////////agentPool->writeDebugMessage("got one");
	Position target = buildings.at(scanFocus)->getLastKnownPosition();
	//////////////agentPool->writeDebugMessage("got its position");

	std::set<BaseLocation*> b = BWTA::getBaseLocations();
	Position baseTarget = Position(-1,-1);
	std::vector<Position> candidates;
	for(std::set<BaseLocation*>::const_iterator i = b.begin(); i != b.end(); i++) {
		if((*i)->getTilePosition().getDistance((TilePosition)buildings.at(0)->getLastKnownPosition()) < 1450) {
			candidates.push_back((*i)->getPosition());
		}
	}
	//////////////agentPool->writeDebugMessage("getting rand base");
	baseTarget = candidates.at(rand()%(candidates.size()));

	if(rand()%100 >= 50) {
		target = baseTarget;
	} 

	Unit* scanner = NULL;

	std::set<Unit*> myBuildings = Broodwar->self()->getUnits();
	for(std::set<Unit*>::const_iterator i = myBuildings.begin(); i != myBuildings.end(); i++) {
		Unit* cur = *i;
		if(cur->isCompleted()) {
			if(cur->getType() == UnitTypes::Terran_Command_Center) {
				if(cur->getAddon() != NULL) {
					if(cur->getAddon()->isCompleted()) {
					if(cur->getAddon()->getEnergy() > 80) {
						scanner = cur->getAddon();
						break;
					}
					}
				}
			}
		}
	}
	if(scanner != NULL) {
		//////////agentPool->writeDebugMessage("executing scan");
		
		bool s = scanner->useTech(TechTypes::Scanner_Sweep, Position(target.x(), target.y()));
		////Broodwar->sendText("scan status... %d", s);
		//////////////////////////agentPool->writeDebugMessage("scan status: ");
		//////////////////////////agentPool->writeDebugMessage(s);

	}



}


bool InformationManagerAgent::hasActiveRefineryAtBase() {
	std::vector<BaseModel*> bases = getBases();
	for(unsigned int i = 0; i < bases.size(); i++) {
		BaseModel* currentBase = bases.at(i);
		for(unsigned int k = 0; k < currentBase->getLocalGas().size(); k++) {
			GasModel* currentGas = currentBase->getLocalGas().at(k);
			if(currentGas->hasRefinery()) {
				//////////////////////////////agentPool->writeDebugMessage("found a base with a refinery");
				return true;
			}
		}
	}
	//////////////////////////////agentPool->writeDebugMessage("found no bases with a refinery");
	return false;	

}

bool InformationManagerAgent::hasUnit(UnitType t) {
	//////////agentPool->writeDebugMessage("looking for a... ");
	//////////agentPool->writeDebugMessage(t.getName());
	if(t.isBuilding()) {
		for(unsigned int i = 0; i < buildingSet.size(); i++) {
			if(buildingSet.at(i)->unitIsKnown()) {
				if(buildingSet.at(i)->getUnitType() == t && buildingSet.at(i)->getUnit()->isCompleted()) {
					//////////agentPool->writeDebugMessage("yes! we have a ");
					//////////agentPool->writeDebugMessage(t.getName());
					return true;
				}
			}
		}
	} else {
		for(unsigned int i = 0; i < unitSet.size(); i++) {
			if(unitSet.at(i)->unitIsKnown() && unitSet.at(i)->isAlive()) {
				if(unitSet.at(i)->getUnitType() == t && unitSet.at(i)->getUnit()->isCompleted()) {
					//////////////////////////////agentPool->writeDebugMessage("yes! we have a ");
					//////////////////////////////agentPool->writeDebugMessage(t.getName());
					return true;
				}
			}
		}
	}


	//////////agentPool->writeDebugMessage("no! we do not have a ");
	//////////agentPool->writeDebugMessage(t.getName());
	return false;
}


bool InformationManagerAgent::hasUnit(Unit* t) {
	//////////////////////////agentPool->writeDebugMessage("looking for a... ");
	//////////////////////////agentPool->writeDebugMessage(t.getName());
	if(t->getType().isBuilding()) {
		for(unsigned int i = 0; i < buildingSet.size(); i++) {
			if(buildingSet.at(i)->unitIsKnown()) {
				if(buildingSet.at(i)->getUnit() == t) {
					return true;
				}
			}
		}
	} else {
		for(unsigned int i = 0; i < unitSet.size(); i++) {
			if(unitSet.at(i)->unitIsKnown()) {
				if(unitSet.at(i)->getUnit() == t) {
					return true;
				}
			}
		}
	}


	//////////////////////////////agentPool->writeDebugMessage("no! we do not have a ");
	//////////////////////////////agentPool->writeDebugMessage(t.getName());
	return false;
}



bool InformationManagerAgent::hasUnitUnderConstruction(UnitType t) {
	if(t.isBuilding()) {
		for(unsigned int i = 0; i < buildingSet.size(); i++) {
			if(buildingSet.at(i)->unitIsKnown() && buildingSet.at(i)->isAlive()) {
				if(buildingSet.at(i)->getUnitType() == t && !buildingSet.at(i)->getUnit()->isCompleted()) {
					return true;
				}
			}
		}
	} else {
		for(unsigned int i = 0; i < unitSet.size(); i++) {
			if(unitSet.at(i)->unitIsKnown() && unitSet.at(i)->isAlive()) {
				if(unitSet.at(i)->getUnitType() == t && !unitSet.at(i)->getUnit()->isCompleted()) {
					return true;
				}
			}
		}
	}



	return false;
}

std::vector<UnitModel*> InformationManagerAgent::getKnownBuildings() {
	std::vector<UnitModel*> output;
	for(unsigned int i = 0; i < buildingSet.size(); i++) {
		if(buildingSet.at(i)->unitIsKnown() && buildingSet.at(i)->isAlive()) {
			output.push_back(buildingSet.at(i));
		}
	}
	return output;
}

std::vector<UnitModel*> InformationManagerAgent::getKnownBuildingsAroundPoint(Position p, int radius) {
	std::vector<UnitModel*> output;
	for(unsigned int i = 0; i < buildingSet.size(); i++) {
		if(buildingSet.at(i)->unitIsKnown() && buildingSet.at(i)->isAlive()) {
			if(buildingSet.at(i)->getLastKnownPosition().getDistance(p) <= radius) {
				output.push_back(buildingSet.at(i));
			}
		}
	}
	return output;

}

std::vector<UnitModel*> InformationManagerAgent::getKnownUnitsAroundPoint(Position p, int radius) {
	std::vector<UnitModel*> output;
	for(unsigned int i = 0; i < unitSet.size(); i++) {
		if(unitSet.at(i)->unitIsKnown() && unitSet.at(i)->isAlive()) {
			if(unitSet.at(i)->getLastKnownPosition().getDistance(p) <= radius) {
				output.push_back(unitSet.at(i));
			}
		}
	}
	return output;

}

std::vector<Unit*> InformationManagerAgent::getBuildingsOfType(UnitType u) {
	std::vector<Unit*> output;
	for(unsigned int i = 0; i < buildingSet.size(); i++) {
		if(buildingSet.at(i)->unitIsKnown() && u == buildingSet.at(i)->getUnitType() && buildingSet.at(i)->isAlive()) {
			output.push_back(buildingSet.at(i)->getUnit());
		}
	}
	return output;
}

std::vector<Unit*> InformationManagerAgent::getUnitsOfType(UnitType u) {
	std::vector<Unit*> output;
	if(u.isBuilding()) {
		for(unsigned int i = 0; i < buildingSet.size(); i++) {
				if(buildingSet.at(i)->unitIsKnown() && u == buildingSet.at(i)->getUnitType() && buildingSet.at(i)->isAlive() && buildingSet.at(i)->getUnit()->isCompleted()) {
					output.push_back(buildingSet.at(i)->getUnit());
				}
		}
	} else {
	for(unsigned int i = 0; i < unitSet.size(); i++) {

		if(u == UnitTypes::Terran_Siege_Tank_Siege_Mode || u == UnitTypes::Terran_Siege_Tank_Tank_Mode) {
			if(unitSet.at(i)->unitIsKnown() && (unitSet.at(i)->getUnitType() == UnitTypes::Terran_Siege_Tank_Siege_Mode || unitSet.at(i)->getUnitType() == UnitTypes::Terran_Siege_Tank_Tank_Mode) && unitSet.at(i)->isAlive() && unitSet.at(i)->getUnit()->isCompleted()) {
				output.push_back(unitSet.at(i)->getUnit());
			}

		} else {

			if(unitSet.at(i)->unitIsKnown() && u == unitSet.at(i)->getUnitType() && unitSet.at(i)->isAlive() && unitSet.at(i)->getUnit()->isCompleted()) {
				output.push_back(unitSet.at(i)->getUnit());
			}
		}
	}
	}
	return output;
}


std::vector<Unit*> InformationManagerAgent::getUnitsOfType(std::pair<UnitType,UnitType> u) {
	std::vector<Unit*> output;
	for(unsigned int i = 0; i < unitSet.size(); i++) {

		if(u.first == unitSet.at(i)->getUnitType() || u.second == unitSet.at(i)->getUnitType()){
			output.push_back(unitSet.at(i)->getUnit());
		}
	}
	return output;
}


int InformationManagerAgent::countUnitType(UnitType t) {
	int c = 0;
	////////////agentPool->writeDebugMessage("counting ");
	////////////agentPool->writeDebugMessage(t.getName());
	if(t.isBuilding()) {
		for(unsigned int i = 0; i < buildingSet.size(); i++) {
			UnitModel* m = buildingSet.at(i);
			if(m->getUnitType() == t)
				if(m->unitIsKnown()) {
					if(m->getUnit()->isCompleted() && m->isAlive()) {
						c++;
					}
				}
			}
		
	} else {
		for(unsigned int i = 0; i < unitSet.size(); i++) {
			UnitModel* m = unitSet.at(i);
			if(m->getUnitType() == t && m->getUnit()->isCompleted() && m->isAlive()) {
				c++;
			}
		}
	}
	return c;
}

bool InformationManagerAgent::isProducedBy(Unit* u, UnitType t) {
	const std::map<UnitType, int> required = u->getType().requiredUnits();

	for (std::map<UnitType, int>::const_iterator it = required.begin(); it != required.end(); ++it)
	{
		if((*it).first == t) {
			return true;
		}
	}

	return false;
}

std::vector<Unit*> InformationManagerAgent::getUnitsThatProduce(Unit* u) {
	std::vector<Unit*> output;
	for(unsigned int i = 0; i < buildingSet.size(); i++) {
		UnitModel* m = buildingSet.at(i);
		if(m->unitIsKnown() && isProducedBy(u, m->getUnitType())) {
			output.push_back(m->getUnit());
		}
	}
	return output;
}

	Unit* InformationManagerAgent::selectNewMainBase() {
		Unit* currentBase = agentPool->getCurrentPrimaryBase();
		Unit* newBase = NULL;
		for(int i = 0; i < bases.size(); i++) {
			Region* bestRegion = NULL;
			if(bases.at(i)->getCentre() != currentBase) {
				BWTA::Region* r = BWTA::getRegion((TilePosition)bases.at(i)->getPosition());
				if(bestRegion == NULL) {
					bestRegion = r;
				} else {
					if(r->getPolygon().getArea() > bestRegion->getPolygon().getArea()) {
						bestRegion = r;
					}
				}

			}
		}
		return newBase;
	}

void InformationManagerAgent::destroyed(Unit* u) {
	////////////////agentPool->writeDebugMessage("destroying...");
	if(u->getType().isBuilding()) {
		//////////////////////////////agentPool->writeDebugMessage("building...");
		for(unsigned int i = 0; i < buildingSet.size(); i++) {
			if(buildingSet.at(i)->unitIsKnown()) {
				if(u->getID() == buildingSet.at(i)->getUnit()->getID()) {
					buildingSet.at(i)->dead();
					////////////////agentPool->writeDebugMessage("done... seeing if it was a base");
					if(u->getPlayer()->getRace().getCenter()) {
						////////////////agentPool->writeDebugMessage("found a command centre to destroy");
						for(std::vector<BaseModel*>::iterator l = bases.begin(); l != bases.end(); l++) {
							if((*l)->getCentre() == u) {
								
								if(u->getPlayer() == Broodwar->self()) {
									if(agentPool->getCurrentPrimaryBase() == u) {
										Unit* newBase = selectNewMainBase();
										if(newBase != NULL) {
											agentPool->setCurrentPrimaryBase(newBase);
										}
									}
								}

								//agentPool->writeDebugMessage("bases");
								//agentPool->writeDebugMessage("size before:");
								////agentPool->writeDebugMessage((int)bases.size());
								if(bases.size() > 1) {
									//agentPool->writeDebugMessage("deleting individual base");
									l = bases.erase(l);
								} else {
									//agentPool->writeDebugMessage("clearing base!");
									bases.clear();
								}
								//agentPool->writeDebugMessage("bases");
								//agentPool->writeDebugMessage("size after:");
								//agentPool->writeDebugMessage((int)bases.size());
								break;
							}
						}
					}
				}
			}
		}
	} else {
		////////////////agentPool->writeDebugMessage("unit...");
		for(unsigned int i = 0; i < unitSet.size(); i++) {
			if(unitSet.at(i)->unitIsKnown()) {
				if(u->getID() == unitSet.at(i)->getUnit()->getID()) {
					unitSet.at(i)->dead();
					if(unitSet.at(i)->getUnit()->getPlayer() == Broodwar->self()) {
						////////agentPool->writeDebugMessage("killing unit...");
						MilitaryProductionManagerAgent* m = (MilitaryProductionManagerAgent*)agentPool->getAgent("MP");
						m->receiveAlert(unitSet.at(i)->getUnit()->getType(), false, unitSet.at(i)->getUnit()->getID());
					}
					break;
				}
			}
		}
	}
}

void InformationManagerAgent::updateDrives() {
		////////////agentPool->writeDebugMessage("processing information");
	if(!bases.empty()){
		for(unsigned int i = 0; i < bases.size(); i++) {
			if(bases.at(i)->getCentre()->getPlayer() != Broodwar->self()) {
				Broodwar->drawCircle(CoordinateType::Map, bases.at(i)->getPosition().x(), bases.at(i)->getPosition().y(), 450, Colors::Red,false);
				InformationManagerAgent* eim = (InformationManagerAgent*)agentPool->getAgent("EI");
				Broodwar->drawText(CoordinateType::Map, bases.at(i)->getPosition().x(), bases.at(i)->getPosition().y()-64, "strength: %d", tf->calculateBaseFitness(bases.at(i), eim));
			} else {

				Broodwar->drawCircle(CoordinateType::Map, bases.at(i)->getPosition().x(), bases.at(i)->getPosition().y(), 450, Colors::Green,false);
			}
			}
	}

	if(!pending.empty()) {
		while(!pending.empty()) {
			
				if(!hasUnit(pending.top()) && pending.top()->getPlayer() == Broodwar->self()) {
					MilitaryProductionManagerAgent* m = (MilitaryProductionManagerAgent*)agentPool->getAgent("MP");
					m->receiveAlert(pending.top()->getType(), true, pending.top()->getID());
				}
						////////////agentPool->writeDebugMessage("updating nnwoeldgen");
			updateKnowledge(pending.top());
			pending.pop();
		}
	}
}

void InformationManagerAgent::printUnits() {
	int space = 16;
	for(unsigned int i = 0; i < unitSet.size(); i++) {
		Broodwar->drawTextScreen(174, space, unitSet.at(i)->getUnitType().getName().c_str());
		space+=16;
	}
}

void InformationManagerAgent::printBuildings() {
	int space = 16;
	for(unsigned int i = 0; i < buildingSet.size(); i++) {
		Broodwar->drawTextScreen(266, space, buildingSet.at(i)->getUnitType().getName().c_str());
		space+=16;
	}
}

std::vector<BaseModel*> InformationManagerAgent::getBases() {
	return bases;
}

bool InformationManagerAgent::baseIsTaken(Unit* u) {
	std::vector<BaseModel*> bases = getBases();
	if(bases.empty()) {
		return false;
	}
	for(unsigned int i = 0; i < bases.size(); i++) {
		BaseModel* currentBase = bases.at(i);
		if(u->getPosition().getDistance(currentBase->getPosition()) < 300) {
			return true;
		}
	}
	return false;
}



bool InformationManagerAgent::baseIsTaken(TilePosition u) {
	std::vector<BaseModel*> bases = getBases();
	if(bases.empty()) {
		return false;
	}
	for(unsigned int i = 0; i < bases.size(); i++) {
		BaseModel* currentBase = bases.at(i);
		if(currentBase->getPosition().getDistance((Position)u) < 300) {
			return true;
		}
	}
	return false;
}

BaseModel* InformationManagerAgent::getBase(TilePosition p) {
	std::vector<BaseModel*> bases = getBases();
	if(bases.empty()) {
		return NULL;
	}
	for(unsigned int i = 0; i < bases.size(); i++) {
		BaseModel* currentBase = bases.at(i);
		if(currentBase->getPosition().getDistance((Position)p) < 600) {
			return currentBase;
		}
	}
	return NULL;
}



void InformationManagerAgent::addBase(TilePosition p, Unit* u) {
	//////////////////////////agentPool->writeDebugMessage("adding new base");
	if(!baseIsTaken(p) && !baseIsTaken(u)) {
	BaseModel* newBase = new BaseModel(agentPool, u);
	newBase->initialize();
	bases.push_back(newBase);
	}
}

//
// TODO: use this to infer building types from unit encounters
//
bool InformationManagerAgent::updateKnowledge(Unit* u) {
	////////////agentPool->writeDebugMessage(u->getType().getName().c_str());
	if(u->getType().isBuilding()) {
	
		if(u->getType() == u->getPlayer()->getRace().getCenter()) {
			// we're cool, since we can be sure we haven't seen this unit before, we can just add it
			////////////agentPool->writeDebugMessage("checking to see if base is taken");
			if(!baseIsTaken(u)) {
				////////////agentPool->writeDebugMessage("adding new base");
				addBase(u->getTilePosition(), u);
			}
		}

		//////////////////////////////agentPool->writeDebugMessage("now update the kb");
		/*
		First, try to update information if this is a unit we
		already have on file.
		*/
		for(unsigned int i = 0; i < buildingSet.size(); i++) {
			UnitModel* m = buildingSet.at(i);

			// do we already know about this unit?
			if(m->unitIsKnown()) {
				//////////////////////////////agentPool->writeDebugMessage("unit is known");
				// do we already know about this specific building?
				if(m->getUnit()->getID() == u->getID()) {
					//////////////////////////////agentPool->writeDebugMessage("upadting postition");
					m->setLastKnownPosition(u->getPosition());
					//////////////////////////////agentPool->writeDebugMessage("done");
					return true;
				}
			} else {
				// do we know about this TYPE of building already?
				// ie. do we know the opponent has one of these, but not
				// where it is, exactly?
				//////////////////////////////agentPool->writeDebugMessage("do we know what this is?");
				if(m->typeIsKnown()) {
					//////////////////////////////agentPool->writeDebugMessage("got it!");
					if(m->getUnitType() == u->getType()) {
						//////////////////////////////agentPool->writeDebugMessage("trying to update");
						m->assignUnit(u);
						//////////////////////////////agentPool->writeDebugMessage("udpated");
						return true;
					}
				}
			}
		}

		/*
		Ok, so if we got here... it means we probably haven't seen this
		unit before. So we need to add it to the data structure and quit.
		*/
		////////////////////////////agentPool->writeDebugMessage("adding to model");
		////////////////////////////agentPool->writeDebugMessage(u->getType().getName());
		buildingSet.push_back(new UnitModel(u));
		//////////////////////////////agentPool->writeDebugMessage("done");
		/*
		Ok so we know about this building, but also... is it a base?
		if so, we need to add it to our list of bases.
		*/



		return true;
	}
	/*
	right, ok, so maybe it wasn't a building? just do the same thing as above, but
	check the structure for actual combat units instead.
	*/
	if(!u->getType().isBuilding()) {
		////////////////////////////agentPool->writeDebugMessage("is not a building");
		/*
		First, try to update information if this is a unit we
		already have on file.
		*/

		for(unsigned int i = 0; i < unitSet.size(); i++) {
			UnitModel* m = unitSet.at(i);

			// do we already know about this unit?
			if(m->unitIsKnown()) {
				// do we already know about this specific enemy?
				if(m->getUnit()->getID() == u->getID()) {
					m->setLastKnownPosition(u->getPosition());
					return true;
				}
			} else {
				// do we know about this TYPE of enemy already?
				// ie. do we know the opponent has one of these, but not
				// where it is, exactly?
				if(m->typeIsKnown()) {
					if(m->getUnitType() == u->getType()) {
						m->assignUnit(u);
						m->setLastKnownPosition(u->getPosition());
							if(u->getPlayer() == Broodwar->enemy()) {
						inferKnowledge(u);
							}
						return true;
					}
				}
			}
		}

		/*
		Ok, so if we got here... it means we probably haven't seen this
		unit before. So we need to add it to the data structure and quit.
		*/
		////////////////////////////agentPool->writeDebugMessage("adding to model");
		////////////////////////////agentPool->writeDebugMessage(u->getType().getName());
		unitSet.push_back(new UnitModel(u));

		// now infer any new information gained from seeing this unit, if it is an enemy unit
		if(u->getPlayer() == Broodwar->enemy()) {
		inferKnowledge(u);
		}
		return true;
	}

	// just in case everything goes wrong!
	return false;
}


bool InformationManagerAgent::inferKnowledge(Unit* u) {
	////////////////////////////agentPool->writeDebugMessage("inferring knowledge");
	const std::map<UnitType, int> required = u->getType().requiredUnits();

	for (std::map<UnitType, int>::const_iterator it = required.begin(); it != required.end(); ++it)
	{

		UnitType producer = (*it).first;
		bool producerFound = false;
		// do we know about this already?
		for(unsigned int i = 0; i < buildingSet.size(); i++) {
			UnitModel* m = buildingSet.at(i);
			// do we already know about this unit?
			if(m->typeIsKnown()) {
				// do we already know about this specific building?
				if(m->getUnitType() == producer) {
					producerFound = true;
				}
			}
		}
		if(producerFound) {
			continue;
		}
		buildingSet.push_back(new UnitModel(producer));
	}
	return true;



}



std::vector<UnitModel*> InformationManagerAgent::evaluateThreatAt(Position p) {
	//////////////////////////////agentPool->writeDebugMessage("evaluating threat point...");
	std::vector<UnitModel*> output;
	if(buildingSet.empty()) {
		return output;
	}


	for(unsigned int i = 0; i < buildingSet.size(); i++) {
		UnitModel* u = buildingSet.at(i);
		////////////////////////////agentPool->writeDebugMessage("got one, checking to see if we have the unit... ");
		if(u->unitIsKnown() == true) {
			////////////////////////////agentPool->writeDebugMessage("got the unit");
			if(u->getUnit()->isCompleted()) {
				////////////////////////////agentPool->writeDebugMessage("evaluating pos");
				if(u->getUnitType().isBuilding()) {
					////////////////////////////agentPool->writeDebugMessage("is a building...");
					if(u->getUnitType().canAttack()) {
						////////////////////////////agentPool->writeDebugMessage("can attack, evaluating weapons");
						if(u->getUnit()->getPosition().getApproxDistance(p) <= Broodwar->self()->groundWeaponMaxRange(u->getUnitType())){
							output.push_back(u);
							continue;
						}
						if(u->getUnit()->getPosition().getApproxDistance(p) <= Broodwar->self()->airWeaponMaxRange(u->getUnitType())) {
							output.push_back(u);
							continue;
						}
					}
				
			}
		}
	}
	
}
	return output;
}


int InformationManagerAgent::getAirThreat(Position p) {
		std::vector<UnitModel*> units = evaluateThreatAt(p);
		int score = 0;
		if(units.empty()) {
			return score;
		}

		for(unsigned int i = 0; i < units.size(); i++) {
			Unit* curUnit = units.at((i))->getUnit();
			if(curUnit->getType().airWeapon() == WeaponTypes::None) {

			} else {
				score = score + 10;
				if(curUnit->getType() == UnitTypes::Zerg_Spore_Colony || curUnit->getType() == UnitTypes::Protoss_Photon_Cannon ||  curUnit->getType() == UnitTypes::Terran_Missile_Turret) {
					score = score + 20;
				}
			}
		}


		return score;
	}


