#include "GoliathMicroTactics.h"
#include "CrawlingBallAttack.h"
#include <cmath>


GoliathMicroTactics::GoliathMicroTactics(Unit* u, CrawlingBallAttack* s) {
	element = u;
	closestEnemy = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	wait = 0;
	movementLagTimer = 0;
	initialMovementLag = 0;
	lastTarget = NULL;
	squadTactics = s;
	knownType = u->getType();
}

GoliathMicroTactics::GoliathMicroTactics(Unit* u, int movementLag) {
	element = u;
	closestEnemy = NULL;
	fitnessCalculator = new TargetFitnessCalculator();
	wait = 0;
	movementLagTimer = movementLag;
	initialMovementLag = movementLag;
	lastTarget = NULL;
	knownType = u->getType();
}
UnitType GoliathMicroTactics::getKnownType() {
	return knownType;
}

void GoliathMicroTactics::move(Position p) {
	if(element->isUnderDisruptionWeb()) {
		if(Broodwar->getFrameCount()%8==0) {
			int newX = 120+(rand()%64);
			int newY = 80+(rand()%64);
			if(rand()%100 >= 50) newX = -newX;
			if(rand()%100 >= 50) newY = -newY;
			element->move(Position(element->getPosition().x()+newX,element->getPosition().y()+newY));
		}
	}
	int initPopSize = 64;
	int initPopVariance = 128;
	std::vector<Position> population;
	std::vector<Position> solution;
	std::set<Unit*> stuffInRange = element->getUnitsInRadius(element->getType().sightRange());
	std::vector<Unit*> dangerFilter;
	for (std::set<BWAPI::Unit*>::const_iterator it = stuffInRange.begin(); it != stuffInRange.end(); ++it)
	{
		Unit* target = *it;
		if(target->getPlayer() != Broodwar->self() && !target->getType().isNeutral()) {
		if(target->getType() == UnitTypes::Zerg_Sunken_Colony || target->getType() == UnitTypes::Terran_Bunker  || target->getType() == UnitTypes::Protoss_Photon_Cannon) {
			dangerFilter.push_back(target);
		}
		}
	}
	// generate population
	for(int i = 0; i < initPopSize; i++) {
		Position newPosition = element->getPosition();
		int newX = rand()%initPopVariance;
		int newY = rand()%initPopVariance;
		if(rand()%100 >= 50) newX = -newX;
		if(rand()%100 >= 50) newY = -newY;
		newPosition = Position(element->getPosition().x()+newX, element->getPosition().y()+newY);

			population.push_back(newPosition);

	}

	// find the best member
	Position bestPosition = element->getPosition();
	int bestFitness = 90000;
	for(int i = 0; i < initPopSize; i++) {
		Position n = population.at(i);
		int threatOfMove = 0;
		for(unsigned int k = 0; k < dangerFilter.size(); k++) {
			int distance = n.getDistance(dangerFilter.at(k)->getPosition());
			int minRange = dangerFilter.at(k)->getType().groundWeapon().minRange();
			int maxRange = dangerFilter.at(k)->getType().groundWeapon().maxRange();
			if(minRange < distance && maxRange >= distance) {
					threatOfMove+=250;
			}
		}
		
		int fitness = n.getApproxDistance(p) + threatOfMove;
		if(fitness < bestFitness && element->hasPath(n)) 
		{
					bestPosition = n;
					bestFitness = fitness;
					solution.push_back(n);
			}

	}


			element->move(bestPosition);


}

	void GoliathMicroTactics::setMovementLag(int l) {
		initialMovementLag = l;
		movementLagTimer = l;
	}

	bool GoliathMicroTactics::executeTactics() {

		std::set<Unit*> stuffInRange = element->getUnitsInWeaponRange(element->getType().groundWeapon());
		int nearByEnemies = 0;
		int bestFitness = 0;
		Unit* nz = NULL;
		int z = 0;
		for (std::set<BWAPI::Unit*>::const_iterator it = stuffInRange.begin(); it != stuffInRange.end(); ++it)
		{
			if((*it)->getPlayer()->getID() != Broodwar->self()->getID() && (*it)->getHitPoints() > 0 && !(*it)->getType().isNeutral() && !(*it)->getType().isSpecialBuilding() && (*it)->getType() != UnitTypes::Zerg_Larva && (*it)->getType() != UnitTypes::Zerg_Egg) {
				nearByEnemies++;	
				if(closestEnemy == NULL || closestEnemy->getHitPoints() <= 0) {
					closestEnemy = *it;
				} else {

					int targetFitness = fitnessCalculator->calculateMechFitness(*it);
						if(closestEnemy->getType().size() == UnitSizeTypes::Large) {
							targetFitness += 500;
						}
						if(closestEnemy->getType().size() == UnitSizeTypes::Medium) {
							targetFitness += 250;
						}

					if(targetFitness > fitnessCalculator->calculateMechFitness(closestEnemy)) {
						bestFitness = targetFitness;
						closestEnemy = *it;
					}
				}
				if(((*it)->getType() == Protoss_Zealot || (*it)->getType() == Zerg_Zergling) && (*it)->getDistance(element) <= 96) {
					z++;
					if(nz == NULL) {
						nz = *it;
					} else{
						if(element->getDistance(*it) < element->getDistance(nz)) {
							nz = *it;
						}
					}

				}

			}
		}
		if(nz != NULL && element->getHitPoints() < element->getType().maxHitPoints()) {
			int tx = nz->getPosition().x();
			int ty = nz->getPosition().y();
			int mx = element->getPosition().x();
			int my = element->getPosition().y();

			int nx = 0;
			int ny = 0;

			// if the enemy is to my right
			if(tx >= mx) {
				// move far left
				nx = (tx-350);
			} else {
				// move far right
				nx = tx+350;
			}

			// if the enemy is below me
			if(ty >= my) {
				// move up
				ny = (ty-350);
			} else {
				// move down
				ny = (ty+350);
			}
			////Broodwar->sendText("bailing!");
			if(element->isSieged()) {
				element->unsiege();
			}
			move(Position(nx,ny));
			return true;
		}
		std::vector<MicroTacticsModel*> tanks = squadTactics->getSubTeam(UnitTypes::Terran_Siege_Tank_Siege_Mode);
		if(!tanks.empty()) {
			Position tankLine;

			int avgX = 0;
			int avgY = 0;
			int siegedTanks = 0;
			// find where the tanks are
			for(unsigned int i = 0; i < tanks.size(); i++) {
				if(tanks.at(i)->getUnit()->isSieged()) {
					avgX = avgX + tanks.at(i)->getUnit()->getPosition().x();
					avgY = avgY + tanks.at(i)->getUnit()->getPosition().y();
					siegedTanks++;
				}
			}
			//if(siegedTanks == 0) {

			//} else {
			// find the average position
			if(siegedTanks != 0) {
				avgX = avgX/siegedTanks;
				avgY = avgY/siegedTanks;
				tankLine = Position(avgX, avgY);

				// now... we might already be AT the tank line
				// in which case, we just want to shoot stuff...
				// but if we're far away, lets move towards it
				if(element->getPosition().getDistance(tankLine) > 200) {


					// move there
					if(!element->isMoving()) {
						element->attack(tankLine);
					}

					//}
					return true;
				} else {
					////////Broodwar->sendText("i'm at the tank line!");

					if(nearByEnemies != 0) {
						if(element->getGroundWeaponCooldown() <= 0) {
							if(closestEnemy->getHitPoints() > 0) {
								element->attack(closestEnemy);
								return true;
							}
						}
					} else {
						if(element->getPosition().getDistance(Position(tankLine)) > 130) {
							move(tankLine);
							return true;
						}
					}
				}
			}

		}

		if(nearByEnemies != 0) {
			// shoot stuff!
			if(element->getGroundWeaponCooldown() <= 0 || closestEnemy != element->getOrderTarget()) {
				//if(!element->isAttacking()) {
					element->attack(closestEnemy);
				//}
			}
			lastTarget = closestEnemy;
			return true;
		} else {
			return false;
		}


	}


Unit* GoliathMicroTactics::getUnit() {
	return element;
}

