#ifndef GOALGENERATOR_H
#define GOALGENERATOR_H
#include "BWAPI.h"
#include "Arbitrator.h"
#include "AgentPool.h"
#include "GoalTypes.h"

/*
	Headers for specific implementations of this class are stored in separate files relating to which
	agent they concern. ie. Resource_GoalHeaders.h contains class headers for all goals instantiated
	by the resource manager agent.
*/

using namespace BWAPI;

class GoalGeneratorBase {
public:
	
	virtual void updateDrives() = 0;
	virtual bool instantiateGoal() = 0;
	virtual void inhibit() = 0;
	virtual void initialize() = 0;
	virtual int getthresh() = 0;
	virtual int getdrive() = 0;


private:
	// generic stuff
	bool inhibited;
	AgentPool* agentPool;
	int drive;
	int threshold;
	int priority;

	// what afterwards, like task-specific vars
	

};



#endif