#ifndef GOALDESCRIPTOR_H
#define GOALDESCRIPTOR_H
#include "GoalTypes.h"
#include "BWAPI.h"
#include "BidManager.h"
#include "SquadTacticsModel.h"
#include "BaseBuildingSCVTactics.h"

using namespace BWAPI;


class GoalDescriptor {

public:
	GoalDescriptor(int type, int priority, int mineralCost, int gasCost, BidManager* bm);
	int GoalDescriptor::getGoalType();
	int GoalDescriptor::getGoalPriority();

	int GoalDescriptor::getMineralCost();
	int GoalDescriptor::getGasCost();
	void GoalDescriptor::relinquishResources();
	void GoalDescriptor::reserveResources();

	std::pair<Unit*,Unit*> getTargetInformation();
	void setTargetInformation(std::pair<Unit*,Unit*> i);


	const char* GoalDescriptor::getNaturalName();

	bool GoalDescriptor::isActive();
	void GoalDescriptor::activate();
	void GoalDescriptor::deactivate();

	bool GoalDescriptor::accepted();
	void GoalDescriptor::accept();

	void GoalDescriptor::execute();
	bool GoalDescriptor::isExecuting();

	void GoalDescriptor::finish();
	bool GoalDescriptor::isFinished();
	void GoalDescriptor::reboot();
	void GoalDescriptor::retry();
	bool GoalDescriptor::getCustomFlag();
	void GoalDescriptor::setCustomFlag(bool f);
	void GoalDescriptor::modifyPriority(int p);
	void GoalDescriptor::modifyPrice(int minerals, int gas);
	int GoalDescriptor::getExecutionCount();
	bool GoalDescriptor::canExpendResources();


	void GoalDescriptor::setMonitorTarget(BWAPI::Unit* target);
	void GoalDescriptor::setMonitorTarget(SquadTacticsModel* target);
	void GoalDescriptor::clearMonitorTarget();
	BWAPI::Unit* GoalDescriptor::getMonitorTarget();
	SquadTacticsModel* GoalDescriptor::getSquadMonitorTarget();
	MicroTacticsModel* GoalDescriptor::getTacticsMonitorTarget();
	void GoalDescriptor::setTacticsMonitorTarget(MicroTacticsModel* target);
	 void GoalDescriptor::setInhibit(bool t) { inhibited = t; }
	 bool GoalDescriptor::getInhibitionStatus() { return inhibited; }


private:
	int goalType;
	int goalPriority;
	int mineralCost;
	int gasCost;
	int executionCount;
	bool goalAccepted;
	bool active;
	bool executing;
	bool finished;
	bool relinquished;
	bool flag;
	bool reserved;
	bool inhibited;
	BWAPI::Unit* monitorTarget;
	SquadTacticsModel* squadMonitorTarget;
	MicroTacticsModel* tacticsMonitorTarget;
	BidManager* bidManager;

	std::pair<Unit*,Unit*> targetInformation;
	int map[64][64];


};





#endif