#include "GoalDescriptor.h"

GoalDescriptor::GoalDescriptor(int t, int p, int mc, int gc, BidManager* bm) {
	goalType = t;
	goalPriority = p;
	inhibited = false;
	mineralCost = mc;
	gasCost = gc;
	active = false;
	goalAccepted = false;
	executing = false;
	finished = false;
	relinquished = false;
	reserved = false;
	bidManager = bm;
	flag = false;
	monitorTarget = NULL;
	targetInformation.first = NULL;
	executionCount = 0;
}

MicroTacticsModel* GoalDescriptor::getTacticsMonitorTarget() {
	return tacticsMonitorTarget;
}
void GoalDescriptor::setTacticsMonitorTarget(MicroTacticsModel* target) {
	tacticsMonitorTarget = target;
}

void GoalDescriptor::modifyPrice(int minerals, int gas) {
	gasCost = gas;
	mineralCost = minerals;
}


bool GoalDescriptor::getCustomFlag() {
	return flag;
}
void GoalDescriptor::setCustomFlag(bool f) {
	flag = f;
}

void GoalDescriptor::modifyPriority(int p) {
	if(p < 60) {
	goalPriority = p;
	}
}


int GoalDescriptor::getMineralCost() {
	return mineralCost;
}

void GoalDescriptor::clearMonitorTarget() {
	monitorTarget = NULL;
}

const char* GoalDescriptor::getNaturalName() {
	switch(goalType) {
	case RESOURCE_TRAINWORKER: return "train worker";
	case RESOURCE_BUILDSUPPLY: return "build supply";
	case RESOURCE_BUILDREFINERY: return "build refinery";
	case RESOURCE_BUILDEXPANSION: return "expand to new base";

	case DEFENSE_BUILDAIRDEFENSE: return "build turret";
	case DEFENSE_BUILDGROUNDDEFENSE: return "build bunker";

	case MILITARY_BUILDBARRACKS: return "build barracks";
	case MILITARY_BUILDFACTORY: return "build factory";
	case MILITARY_BUILDARMORY: return "build armory";
	case MILITARY_BUILDACADEMY: return "build academy";
	case MILITARY_BUILDSTARPORT: return "build starport";
	case MILITARY_BUILDENGINEERINGBAY: return "build engineering bay";
	case MILITARY_BUILDSCIENCEFACILITY: return "build science facility";

	case MILITARY_TRAINFIREBAT: return "train firebat";
	case MILITARY_TRAINMARINE: return "train marine";
	case MILITARY_TRAINMEDIC: return "train medic";
	case MILITARY_TRAINTANK: return "train tank";
	case MILITARY_TRAINFLYER: return "train best flyer";
	case MILITARY_TRAINSCIENCEVESSEL: return "train science vessel";
	case OFFENSE_LANDATTACK: return "marine rush";
	case OFFENSE_GASSTEAL: return "gas steal";
	case OFFENSE_SCANPOI: return "scan points of interest";

	case RESEARCH_BIOWEAPONS: return "-- something is broken --";
	case RESEARCH_BIOWEAPONS_MARINERANGE: return "research shells";
	case RESEARCH_BIOWEAPONS_STIMPACKS: return "research stimpacks";
	case RESEARCH_BIOATTACK: return "marine weapons";
	case RESEARCH_BIODEFENSE: return "marine armor";
	case RESEARCH_MECHUTIL_SIEGEMODE: return "research siege mode";
	case RESEARCH_WRAITHCLOAK: return "research cloaking field";
	case RESEARCH_IRRIDATE: return "research irradiate";
	case RESEARCH_EMP: return "research EMP";

	case UPGRADE_SCIENCEFACILITY: return "upgrade science facility";
	case UPGRADE_COMMANDCENTRE: return "-- something is broken --";
	case UPGRADE_COMMANDCENTRE_COMSAT: return "build comsat";
	case UPGRADE_STARPORT: return "build control tower";
	case UPGRADE_FACTORY: return "build machine shop";



	}
	return "-- UNDEFINED --";
}

int GoalDescriptor::getGasCost() {
	return gasCost;
}

int GoalDescriptor::getGoalType() {
	return goalType;
}

int GoalDescriptor::getGoalPriority() {
	return goalPriority;
}

int GoalDescriptor::getExecutionCount() {
	return executionCount;
}

void GoalDescriptor::relinquishResources() {
	if(!relinquished) {
		bidManager->relinquish(mineralCost, gasCost, goalPriority, getGoalType());
		relinquished = true;
	}
}

void GoalDescriptor::reserveResources() {
	if(!reserved) {
		bidManager->reserve(mineralCost, gasCost, goalPriority, getGoalType());
		reserved = true;	
		}
	}

bool GoalDescriptor::isActive(){
	return active;
}
void GoalDescriptor::activate(){
	active = true;
}
void GoalDescriptor::deactivate(){
	active = false;
}

	void GoalDescriptor::retry() {
		executing = false;
		finished = true;
		relinquished = false;
		reserved = true;
	}

bool GoalDescriptor::accepted(){
	return goalAccepted;
}
void GoalDescriptor::accept(){
	goalAccepted = true;
}

bool GoalDescriptor::isExecuting() {
	return executing;
}

	bool GoalDescriptor::canExpendResources() {
		return bidManager->canCashIn(mineralCost, gasCost, goalPriority);
	}

// this is almost certaintly a bad idea
void GoalDescriptor::execute() {
	// what do i even do here?
	//////////Broodwar->sendText("reserving %d minerals for ", mineralCost);
	////////Broodwar->sendText(getNaturalName());
	executing = true;
	relinquished = false;
	executionCount++;
	reserveResources();
}

std::pair<Unit*,Unit*> GoalDescriptor::getTargetInformation() {
	return targetInformation;
}
void GoalDescriptor::setTargetInformation(std::pair<Unit*,Unit*> i) {
	targetInformation.first = i.first;
	targetInformation.second = i.second;

}

void GoalDescriptor::finish() {
		executing = false;
		finished = true;
		relinquished = false;
		reserved = false;
}

void GoalDescriptor::reboot(){
	active = false;
	goalAccepted = false;
	executing = false;
	finished = false;
	relinquished = false;
	flag = false;
	reserved = false;
}


bool GoalDescriptor::isFinished() {
	return finished;
}


void GoalDescriptor::setMonitorTarget(Unit* target) {
	monitorTarget = target;
}

void GoalDescriptor::setMonitorTarget(SquadTacticsModel* target) {
	squadMonitorTarget = target;
}

SquadTacticsModel* GoalDescriptor::getSquadMonitorTarget() {
	return squadMonitorTarget;
}

BWAPI::Unit* GoalDescriptor::getMonitorTarget() {
	return monitorTarget;
}
